/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.diagnostics;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.diagnostics.PingState;
import com.couchbase.client.core.service.ServiceType;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class EndpointPingReport {
    private final ServiceType type;
    private final String id;
    private final String local;
    private final String remote;
    private final PingState state;
    private final Optional<String> namespace;
    private final Duration latency;
    private final Optional<String> error;

    @Stability.Internal
    public EndpointPingReport(ServiceType type, String id, String local, String remote, PingState state, Optional<String> namespace, Duration latency, Optional<String> error) {
        this.type = type;
        this.id = id;
        this.local = local;
        this.remote = remote;
        this.state = state;
        this.namespace = namespace;
        this.latency = latency;
        this.error = error;
    }

    public ServiceType type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public String local() {
        return this.local;
    }

    public String remote() {
        return this.remote;
    }

    public PingState state() {
        return this.state;
    }

    public Duration latency() {
        return this.latency;
    }

    public Optional<String> error() {
        return this.error;
    }

    public Optional<String> namespace() {
        return this.namespace;
    }

    Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.remote != null) {
            map.put("remote", this.remote);
        }
        if (this.local != null) {
            map.put("local", this.local);
        }
        map.put("state", this.state().toString().toLowerCase());
        if (this.id != null) {
            map.put("id", this.id);
        }
        map.put("latency_us", TimeUnit.NANOSECONDS.toMicros(this.latency.toNanos()));
        this.namespace.ifPresent(n -> map.put("namespace", n));
        return map;
    }

    public String toString() {
        return "EndpointPingReport{type=" + (Object)((Object)this.type) + ", id='" + this.id + '\'' + ", local='" + this.local + '\'' + ", remote='" + this.remote + '\'' + ", state=" + (Object)((Object)this.state) + ", namespace=" + this.namespace + ", latency=" + this.latency + ", error=" + this.error + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointPingReport that = (EndpointPingReport)o;
        return this.type == that.type && Objects.equals(this.id, that.id) && Objects.equals(this.local, that.local) && Objects.equals(this.remote, that.remote) && this.state == that.state && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.latency, that.latency) && Objects.equals(this.error, that.error);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.id, this.local, this.remote, this.state, this.namespace, this.latency, this.error});
    }
}

