/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.env.BuilderPropertySetter;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.env.PropertyLoader;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.util.ConnectionString;
import java.util.HashMap;
import java.util.Map;

public class ConnectionStringPropertyLoader
implements PropertyLoader<CoreEnvironment.Builder> {
    private final ConnectionString connectionString;
    private final BuilderPropertySetter setter = new BuilderPropertySetter();
    private static final Map<String, String> COMPAT_ALIAS = new HashMap<String, String>();

    public ConnectionStringPropertyLoader(String connectionString) {
        this.connectionString = ConnectionString.create(connectionString);
    }

    @Override
    public void load(CoreEnvironment.Builder builder) {
        if (this.connectionString.scheme() == ConnectionString.Scheme.COUCHBASES) {
            this.setter.set(builder, "security.enableTls", "true");
        }
        for (Map.Entry<String, String> entry : this.connectionString.params().entrySet()) {
            try {
                String key = entry.getKey();
                if (COMPAT_ALIAS.containsKey(key)) {
                    key = COMPAT_ALIAS.get(key);
                }
                this.setter.set(builder, key, entry.getValue());
            }
            catch (IllegalArgumentException e) {
                throw InvalidArgumentException.fromMessage("Failed to apply connection string property \"" + entry.getKey() + "\". " + e.getMessage(), e);
            }
        }
    }

    static {
        COMPAT_ALIAS.put("certpath", "security.trustCertificate");
    }
}

