/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.common;

import com.cybermkd.common.http.Encoding;
import com.cybermkd.common.util.properties.Prop;
import com.cybermkd.common.util.properties.Proper;
import com.cybermkd.log.Logger;
import java.io.File;

public final class Constant {
    public static final String CONNECTOR = "::";
    public static final String encoding;
    public static final boolean devMode;
    public static final boolean oneParamParse;
    public static final String uploadDirectory;
    public static final Integer uploadMaxSize;
    public static final String[] uploadDenieds;
    public static final String fileRenamer;
    public static final boolean showRoute;
    public static final String apiPrefix;
    public static final String exceptionHolder;
    public static final String[] xForwardedSupports;
    public static final String oauthSigninUrl;
    public static final String oauthErrorUrl;
    public static final int oauthExpires;
    private static final Logger logger;

    static {
        logger = Logger.getLogger(Constant.class);
        Prop constants = null;
        try {
            constants = Proper.use("application.properties");
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
        }
        if (constants == null) {
            encoding = Encoding.UTF_8.toString();
            devMode = false;
            oneParamParse = false;
            uploadDirectory = File.separator + "upload" + File.separator;
            uploadMaxSize = 0xA00000;
            uploadDenieds = new String[0];
            fileRenamer = null;
            showRoute = false;
            apiPrefix = null;
            exceptionHolder = null;
            xForwardedSupports = new String[]{"127.0.0.1"};
            oauthSigninUrl = "";
            oauthErrorUrl = "";
            oauthExpires = 0;
        } else {
            encoding = constants.get("app.encoding", Encoding.UTF_8.name());
            devMode = constants.getBoolean("app.devMode", false);
            oneParamParse = constants.getBoolean("app.oneParamParse", false);
            uploadDirectory = constants.get("app.uploadDirectory", File.separator + "upload" + File.separator);
            uploadMaxSize = constants.getInt("app.uploadMaxSize", 0xA00000);
            String uploadDeniedStr = constants.get("app.uploadDenieds");
            uploadDenieds = uploadDeniedStr == null ? new String[0] : uploadDeniedStr.split(",");
            fileRenamer = constants.get("app.fileRenamer");
            showRoute = constants.getBoolean("app.showRoute", false);
            apiPrefix = constants.get("app.apiPrefix");
            exceptionHolder = constants.get("app.exceptionHolder");
            String xForwardedSupportsStr = constants.get("app.xForwardedSupports");
            xForwardedSupports = xForwardedSupportsStr == null ? new String[0] : xForwardedSupportsStr.split(",");
            oauthSigninUrl = constants.get("app.oauthSigninUrl");
            oauthErrorUrl = constants.get("app.oauthErrorUrl");
            oauthExpires = constants.getInt("app.oauthExpires", 0);
        }
    }
}

