/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.common.entity;

import com.cybermkd.common.entity.CaseInsensitiveMap;
import com.cybermkd.common.entity.Conversion;
import com.cybermkd.common.entity.exception.EntityException;
import com.cybermkd.common.util.Maper;
import com.cybermkd.common.util.json.Jsoner;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class Entity<M extends Entity> {
    private Map<String, Object> attrs = new CaseInsensitiveMap<Object>();
    private Map<String, Object> modifyAttrs = new CaseInsensitiveMap<Object>();

    public abstract Conversion getConversion(String var1);

    public Map<String, Object> getAttrs() {
        return this.attrs;
    }

    public M setAttrs(M entity) {
        return this.setAttrs(((Entity)entity).getAttrs());
    }

    public M setAttrs(Map<String, Object> attrs) {
        for (Map.Entry<String, Object> e : attrs.entrySet()) {
            this.set(e.getKey(), e.getValue());
        }
        return (M)this;
    }

    public Map<String, Object> getModifyAttrs() {
        return this.modifyAttrs;
    }

    public boolean checkMethod() {
        return false;
    }

    public abstract boolean hasColumn(String var1);

    public abstract Class getColumnType(String var1);

    public M set(String attr, Object value) {
        if (this.hasColumn(attr)) {
            this.attrs.put(attr, value);
            this.modifyAttrs.put(attr, value);
            return (M)this;
        }
        throw new EntityException("The attribute name is not exists: " + attr);
    }

    public M init(String attr, Object value) {
        this.attrs.put(attr, value);
        return (M)this;
    }

    public M initAttrs(Map<String, Object> attrs) {
        for (Map.Entry<String, Object> e : attrs.entrySet()) {
            this.init(e.getKey(), e.getValue());
        }
        return (M)this;
    }

    public M initAttrs(M entity) {
        return (M)this.initAttrs((M)((Entity)entity).getAttrs());
    }

    public M put(String attr, Object value) {
        if (this.hasColumn(attr)) {
            this.modifyAttrs.put(attr, value);
        }
        this.attrs.put(attr, value);
        return (M)this;
    }

    public M putAttrs(Map<String, Object> attrs) {
        for (Map.Entry<String, Object> e : attrs.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
        return (M)this;
    }

    public M putAttrs(M entity) {
        return (M)this.putAttrs((M)((Entity)entity).getAttrs());
    }

    public <T> T get(String attr) {
        return (T)this.attrs.get(attr);
    }

    public <T> T get(String attr, Class<T> clazz) {
        if (this.attrs.containsKey(attr)) {
            Object value = this.attrs.get(attr);
            Object result = null;
            if (value != null) {
                result = clazz.isAssignableFrom(value.getClass()) ? value : Jsoner.toObject(Jsoner.toJSON(value), clazz);
            }
            return (T)result;
        }
        throw new EntityException("Attribute '" + attr + "' could not found.");
    }

    public <T> T get(String attr, Object defaultValue) {
        T result = this.get(attr);
        return (T)(result != null ? result : defaultValue);
    }

    public <T> T get(String attr, Class<T> clazz, Object defaultValue) {
        T result = this.get(attr, clazz);
        return (T)(result != null ? result : defaultValue);
    }

    public M remove(String attr) {
        this.attrs.remove(attr);
        this.modifyAttrs.remove(attr);
        return (M)this;
    }

    public M remove(String ... attrs) {
        if (attrs != null) {
            for (String attr : attrs) {
                this.remove(attr);
            }
        }
        return (M)this;
    }

    public M removeNull() {
        Iterator<Map.Entry<String, Object>> it = this.attrs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> e = it.next();
            if (e.getValue() != null) continue;
            it.remove();
        }
        return (M)this;
    }

    public M keep(String ... attrs) {
        if (attrs != null && attrs.length > 0) {
            HashMap<String, Object> newAttrs = new HashMap<String, Object>(attrs.length);
            HashMap<String, Object> newModifyAttrs = new HashMap<String, Object>();
            for (String c : attrs) {
                if (!this.attrs.containsKey(c)) continue;
                newAttrs.put(c, this.attrs.get(c));
                if (!this.modifyAttrs.containsKey(c)) continue;
                newModifyAttrs.put(c, this.attrs.get(c));
            }
            this.attrs.clear();
            this.attrs.putAll(newAttrs);
            this.modifyAttrs.clear();
            this.modifyAttrs.putAll(newModifyAttrs);
        } else {
            this.attrs.clear();
            this.modifyAttrs.clear();
        }
        return (M)this;
    }

    public M keep(String attr) {
        if (this.attrs.containsKey(attr)) {
            Object keepIt = this.attrs.get(attr);
            this.attrs.clear();
            this.attrs.put(attr, keepIt);
            if (this.modifyAttrs.containsKey(attr)) {
                this.modifyAttrs.clear();
                this.modifyAttrs.put(attr, keepIt);
            }
        } else {
            this.attrs.clear();
            this.modifyAttrs.clear();
        }
        return (M)this;
    }

    public M clearAttrs() {
        this.attrs.clear();
        return (M)this;
    }

    public M clearModifyAttrs() {
        this.modifyAttrs.clear();
        return (M)this;
    }

    public M reSetAttrs(Map<String, Object> attrs) {
        this.attrs = attrs;
        return (M)this;
    }

    public M reSetModifyAttrs(Map<String, Object> modifyAttrs) {
        this.modifyAttrs = modifyAttrs;
        return (M)this;
    }

    public String[] getAttrNames() {
        Set<String> attrNameSet = this.attrs.keySet();
        return attrNameSet.toArray(new String[attrNameSet.size()]);
    }

    public Object[] getAttrValues() {
        Collection<Object> attrValueCollection = this.attrs.values();
        return attrValueCollection.toArray(new Object[attrValueCollection.size()]);
    }

    public String[] getModifyAttrNames() {
        return this.getModifyAttrNames(null);
    }

    public String[] getModifyAttrNames(String generatedKey) {
        Set<String> attrNameSet = this.modifyAttrs.keySet();
        if (generatedKey != null && !generatedKey.isEmpty()) {
            attrNameSet.remove(generatedKey);
        }
        return attrNameSet.toArray(new String[attrNameSet.size()]);
    }

    public Object[] getModifyAttrValues() {
        return this.getModifyAttrValues(null);
    }

    public Object[] getModifyAttrValues(String generatedKey) {
        Map<String, Object> attrValueMap = Maper.copyOf(new CaseInsensitiveMap(), this.modifyAttrs);
        if (generatedKey != null && !generatedKey.isEmpty()) {
            attrValueMap.remove(generatedKey);
        }
        for (Map.Entry<String, Object> attrValueEntry : attrValueMap.entrySet()) {
            Conversion conversion = this.getConversion(attrValueEntry.getKey());
            if (conversion == null) continue;
            attrValueEntry.setValue(conversion.write(attrValueEntry.getValue()));
        }
        Collection<Object> attrValueCollection = attrValueMap.values();
        return attrValueCollection.toArray(new Object[attrValueCollection.size()]);
    }

    public String toString() {
        return this.toJson();
    }

    public String toJson() {
        return Jsoner.toJSON(this.attrs);
    }
}

