/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.common.http;

import com.cybermkd.common.Constant;
import com.cybermkd.common.Request;
import com.cybermkd.common.util.Joiner;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;

public abstract class AbstractRequest
implements Request {
    protected AbstractRequest() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[ICEREST request] ");
        sb.append(this.getHttpMethod()).append(" ").append(this.getRestPath());
        this.dumpParams(sb);
        return sb.toString();
    }

    private void dumpParams(StringBuilder sb) {
        Map<String, List<String>> queryParams = this.getQueryParams();
        if (queryParams.isEmpty()) {
            return;
        }
        sb.append("?");
        for (Map.Entry<String, List<String>> entry : queryParams.entrySet()) {
            String key = entry.getKey();
            List<String> values = entry.getValue();
            sb.append(key).append("=").append(values.size() == 1 ? values.get(0) : Joiner.on("&" + key + "=").join(values));
            sb.append("&");
        }
        sb.setLength(sb.length() - 1);
    }

    @Override
    public String getBaseUri() {
        return this.getScheme() + ":" + this.getBaseNetworkPath();
    }

    @Override
    public String getBaseNetworkPath() {
        this.checkProxyRequest();
        return "//" + this.getHost() + this.getBasePath();
    }

    protected String getHost() {
        String forwardedHost = this.getHeader("X-Forwarded-Host");
        if (forwardedHost != null) {
            String[] hosts = forwardedHost.split(",");
            return hosts.length > 0 ? hosts[0] : this.getHeader("Host");
        }
        return this.getHeader("Host");
    }

    @Override
    public boolean isSecured() {
        this.checkProxyRequest();
        return this.getScheme().equalsIgnoreCase("https");
    }

    protected String getScheme() {
        String forwarded = this.getHeader("X-Forwarded-Proto");
        if (forwarded != null) {
            return forwarded;
        }
        String via = this.getHeader("Via");
        if (via != null) {
            boolean secured = via.toUpperCase(Locale.ENGLISH).startsWith("HTTPS");
            return secured ? "https" : "http";
        }
        return this.getLocalScheme();
    }

    @Override
    public String getClientAddress() {
        String[] xffs;
        this.checkProxyRequest();
        String xff = this.getHeader("X-Forwarded-For");
        String address = xff != null ? ((xffs = xff.split(",")).length > 0 ? xffs[0] : this.getLocalClientAddress()) : this.getLocalClientAddress();
        if (address.startsWith("0:0:0:0:0:0:0:1")) {
            address = "127.0.0.1";
        }
        return address;
    }

    protected void checkProxyRequest() {
        if (this.getHeader("X-Forwarded-Proto") != null) {
            List<String> forwardedSupports;
            String localClientAddress = this.getLocalClientAddress();
            if (Constant.xForwardedSupports != null && Constant.xForwardedSupports.length > 0 && ((forwardedSupports = Arrays.asList(Constant.xForwardedSupports)).size() <= 0 || !forwardedSupports.contains("*") && !forwardedSupports.contains(localClientAddress))) {
                throw new IllegalArgumentException("Unauthorized proxy request from " + localClientAddress + "\n" + "If you are the application developer or operator, you can set `app.xForwardedSupports`\n" + "application.properties property to allow proxy requests from this proxy IP with:\n" + "  app.xForwardedSupports=" + localClientAddress + "\n" + "Or if you want to allow any proxy request:\n" + "  app.xForwardedSupports=*");
            }
        }
    }

    protected abstract String getQueryString();

    protected abstract RequestDispatcher getRequestDispatcher(String var1);

    protected abstract String getLocalClientAddress();

    protected abstract String getBasePath();

    protected abstract String getLocalScheme();
}

