/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.common.http;

import com.cybermkd.common.Response;
import com.cybermkd.common.http.Encoding;
import com.cybermkd.common.http.result.HttpStatus;
import com.cybermkd.common.util.HttpTyper;
import com.cybermkd.common.util.Joiner;
import com.cybermkd.log.Logger;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public abstract class AbstractResponse<R>
implements Response {
    private static final Logger logger = Logger.getLogger(AbstractResponse.class);
    private final Class<R> responseClass;
    private final R response;
    private final Map<String, String> headers = new LinkedHashMap<String, String>();
    private HttpStatus status = HttpStatus.OK;
    private Charset charset;
    private PrintWriter writer;
    private OutputStream outputStream;
    private boolean closed;

    protected AbstractResponse(Class<R> responseClass, R response) {
        this.responseClass = responseClass;
        this.response = response;
    }

    @Override
    public HttpStatus getStatus() {
        return this.status;
    }

    @Override
    public Response setStatus(HttpStatus httpStatus) {
        this.status = httpStatus;
        this.doSetStatus(httpStatus);
        return this;
    }

    @Override
    public Response setContentType(String s) {
        if (HttpTyper.isTextContentType(s)) {
            String cs = HttpTyper.charsetFromContentType(s);
            if (cs == null) {
                s = s + ";charset=UTF-8";
                this.charset = Encoding.UTF_8;
            } else {
                this.charset = Charset.forName(cs);
            }
        }
        this.setHeader("Content-Type", s);
        return this;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.charset == null) {
            logger.warn("No charset defined while getting writer to write http response. Make sure you call setContentType() before calling getWriter(). Using UTF-8 charset.");
            this.charset = Encoding.UTF_8;
        }
        this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.doGetOutputStream(), this.charset), true);
        return this.writer;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.outputStream != null) {
            return this.outputStream;
        }
        this.outputStream = this.doGetOutputStream();
        return this.outputStream;
    }

    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        try {
            if (this.writer != null) {
                this.writer.close();
            }
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public Response addCookie(String name, String value) {
        this.addCookie(name, value, -1);
        return this;
    }

    @Override
    public final Response setHeader(String name, String value) {
        this.doSetHeader(name, value);
        this.headers.put(name.toLowerCase(Locale.ENGLISH), value);
        return this;
    }

    public final Response addHeader(String headerName, String header) {
        this.doAddHeader(headerName, header);
        this.headers.put(headerName.toLowerCase(Locale.ENGLISH), Joiner.on(",").join(header, header, new Object[0]));
        return this;
    }

    protected abstract void doSetHeader(String var1, String var2);

    protected abstract void doAddHeader(String var1, String var2);

    @Override
    public String getHeader(String value) {
        return this.headers.get(value.toLowerCase(Locale.ENGLISH));
    }

    public String toString() {
        return "[ICEREST response] " + (Object)((Object)this.status);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz == this.responseClass) {
            return (T)this.response;
        }
        throw new IllegalArgumentException("Underlying implementation is " + this.responseClass.getName() + ", not " + clazz.getName());
    }

    protected abstract OutputStream doGetOutputStream() throws IOException;

    protected abstract void doSetStatus(HttpStatus var1);
}

