/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.common.http;

import com.cybermkd.common.http.AbstractRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class HttpRequest
extends AbstractRequest {
    private final HttpServletRequest request;
    private final ServletContext servletContext;
    private Map<String, List<String>> queryParams;

    public HttpRequest(HttpServletRequest request, ServletContext servletContext) {
        this.request = request;
        this.servletContext = servletContext;
    }

    private static String getCookieValue(Cookie[] cookies, String name) {
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!name.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    static Cookie getCookie(Cookie[] cookies, String name) {
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!name.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    @Override
    public String getLocalClientAddress() {
        return this.request.getRemoteAddr();
    }

    @Override
    protected String getBasePath() {
        return this.request.getContextPath();
    }

    @Override
    protected String getLocalScheme() {
        return this.request.getScheme();
    }

    @Override
    public String getRestPath() {
        int index;
        String basepath = this.getBasePath();
        String requestURI = this.request.getRequestURI();
        if (basepath.length() > 0) {
            requestURI = this.request.getRequestURI().substring(basepath.length());
        }
        if ((index = requestURI.toLowerCase().indexOf(";jsessionid=")) != -1) {
            requestURI = requestURI.substring(0, index);
        }
        try {
            return URLDecoder.decode(requestURI, this.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Invalid character encoding for '" + this.getCharacterEncoding() + "'");
        }
    }

    @Override
    public String getRealPath(String path) {
        return this.servletContext.getRealPath(path);
    }

    @Override
    public String getRestUri() {
        String queryString = this.getQueryString();
        if (queryString == null) {
            return this.getRestPath();
        }
        return this.getRestPath() + "?" + queryString;
    }

    @Override
    public String getQueryParam(String param) {
        return this.request.getParameter(param);
    }

    @Override
    public List<String> getQueryParams(String param) {
        String[] values = this.request.getParameterValues(param);
        if (values != null) {
            return Arrays.asList(values);
        }
        return null;
    }

    @Override
    public Map<String, List<String>> getQueryParams() {
        if (this.queryParams == null) {
            Map<String, String[]> paramMap = this.getParamMap();
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            for (Map.Entry<String, String[]> entry : paramMap.entrySet()) {
                params.put(entry.getKey(), Arrays.asList((Object[])entry.getValue()));
            }
            this.queryParams = params;
        }
        return this.queryParams;
    }

    protected Map<String, String[]> getParamMap() {
        return this.request.getParameterMap();
    }

    @Override
    public int getContentLength() {
        return this.request.getContentLength();
    }

    @Override
    public InputStream getContentStream() throws IOException {
        return this.request.getInputStream();
    }

    @Override
    public String getHttpMethod() {
        String httpMethod = this.request.getMethod();
        if (httpMethod == null) {
            throw new IllegalArgumentException("Invalid HTTP Method for " + this.getRestPath());
        }
        return httpMethod;
    }

    @Override
    public Map<String, String> getCookiesMap() {
        LinkedHashMap<String, String> cookies = new LinkedHashMap<String, String>();
        Cookie[] requestCookies = this.request.getCookies();
        if (requestCookies != null) {
            for (Cookie cookie : requestCookies) {
                cookies.put(cookie.getName(), cookie.getValue());
            }
        }
        return cookies;
    }

    @Override
    public String getCookieValue(String name) {
        return HttpRequest.getCookieValue(this.request.getCookies(), name);
    }

    @Override
    public boolean isPersistentCookie(String cookie) {
        Cookie c = HttpRequest.getCookie(this.request.getCookies(), cookie);
        return c != null && c.getMaxAge() > 0;
    }

    @Override
    public String getQueryString() {
        try {
            String queryString = this.request.getQueryString();
            if (queryString != null && !"".equals(queryString)) {
                return URLDecoder.decode(this.request.getQueryString(), this.getCharacterEncoding());
            }
            return queryString;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Invalid character encoding for '" + this.getCharacterEncoding() + "'");
        }
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String url) {
        return this.request.getRequestDispatcher(url);
    }

    @Override
    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    @Override
    public Enumeration<String> getHeaders(String name) {
        return this.request.getHeaders(name);
    }

    @Override
    public Map<String, String> getHeaders() {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration headerNames = this.request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = this.request.getHeader(key);
            map.put(key, value);
        }
        return map;
    }

    @Override
    public String getContentType() {
        return this.request.getContentType();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz == HttpServletRequest.class || clazz == ServletRequest.class) {
            return (T)this.request;
        }
        throw new IllegalArgumentException("underlying implementation is HttpServletRequest, not " + clazz.getName());
    }

    @Override
    public Locale getLocale() {
        return this.request.getLocale();
    }

    @Override
    public List<Locale> getLocales() {
        return Collections.list(this.request.getLocales());
    }

    @Override
    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    @Override
    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this.request.setCharacterEncoding(encoding);
    }
}

