/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.common.http;

import com.cybermkd.common.Response;
import com.cybermkd.common.http.AbstractResponse;
import com.cybermkd.common.http.HttpRequest;
import com.cybermkd.common.http.result.HttpStatus;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpResponse
extends AbstractResponse<HttpServletResponse> {
    private final HttpServletResponse response;
    private final HttpServletRequest request;

    public HttpResponse(HttpServletResponse response, HttpServletRequest request) {
        super(HttpServletResponse.class, response);
        this.response = response;
        this.request = request;
    }

    @Override
    protected void doSetStatus(HttpStatus httpStatus) {
        this.response.setStatus(httpStatus.getCode());
    }

    @Override
    protected OutputStream doGetOutputStream() throws IOException {
        return this.response.getOutputStream();
    }

    @Override
    public Response addCookie(String name, String value, int expiration) {
        return this.addCookie(name, value, expiration, true);
    }

    public Response addCookie(String name, String value, int expiration, boolean httpOnly) {
        Cookie existingCookie = HttpRequest.getCookie(this.request.getCookies(), name);
        if (existingCookie != null) {
            if ("/".equals(existingCookie.getPath()) || existingCookie.getPath() == null) {
                existingCookie.setPath("/");
                existingCookie.setValue(value);
                existingCookie.setMaxAge(expiration);
                this.response.addCookie(existingCookie);
            } else {
                existingCookie.setValue("");
                existingCookie.setMaxAge(0);
                this.response.addCookie(existingCookie);
                Cookie c = new Cookie(name, value);
                c.setPath("/");
                c.setMaxAge(expiration);
                this.response.addCookie(c);
            }
        } else {
            Cookie c = new Cookie(name, value);
            c.setPath("/");
            c.setMaxAge(expiration);
            this.response.addCookie(c);
        }
        return this;
    }

    @Override
    public Response clearCookie(String cookie) {
        Cookie existingCookie = HttpRequest.getCookie(this.request.getCookies(), cookie);
        if (existingCookie != null) {
            existingCookie.setPath("/");
            existingCookie.setValue("");
            existingCookie.setMaxAge(0);
            this.response.addCookie(existingCookie);
        }
        return this;
    }

    @Override
    public void doSetHeader(String headerName, String header) {
        this.response.setHeader(headerName, header);
    }

    @Override
    public void doAddHeader(String headerName, String header) {
        this.response.addHeader(headerName, header);
    }

    public void forward(String url) throws ServletException, IOException {
        this.request.getRequestDispatcher(url).forward((ServletRequest)this.request, (ServletResponse)this.response);
    }

    public void sendRedirect(String url) throws ServletException, IOException {
        this.response.sendRedirect(url);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz == HttpServletResponse.class || clazz == ServletResponse.class) {
            return (T)this.response;
        }
        throw new IllegalArgumentException("Underlying implementation is HttpServletResponse, not " + clazz.getName());
    }

    public void reset() {
        this.response.reset();
    }
}

