/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.common.http.exception;

import com.cybermkd.common.http.result.HttpStatus;

public class WebException
extends RuntimeException {
    private final HttpStatus status;
    private final Object content;

    public WebException(HttpStatus status) {
        this(status, status.getDesc());
    }

    public WebException(String message) {
        this(HttpStatus.BAD_REQUEST, message);
    }

    public WebException(Object content) {
        this(HttpStatus.BAD_REQUEST, content);
    }

    public WebException(HttpStatus status, String message) {
        super(message);
        this.status = status;
        this.content = null;
    }

    public WebException(HttpStatus status, Object content) {
        this.status = status;
        this.content = content;
    }

    public HttpStatus getStatus() {
        return this.status;
    }

    public Object getContent() {
        return this.content != null ? this.content : this.getMessage();
    }
}

