/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.common.http.result;

import com.cybermkd.common.http.result.HttpStatus;
import java.util.Map;

public class WebResult<T> {
    private final HttpStatus status;
    private final T result;
    private final Map<String, String> headers;

    public WebResult(HttpStatus status) {
        this(status, null, null);
    }

    public WebResult(HttpStatus status, Map<String, String> headers) {
        this(status, null, headers);
    }

    public WebResult(T result) {
        this(HttpStatus.OK, result, null);
    }

    public WebResult(T result, Map<String, String> headers) {
        this(HttpStatus.OK, result, headers);
    }

    public WebResult(HttpStatus status, T result) {
        this(status, result, null);
    }

    public WebResult(HttpStatus status, T result, Map<String, String> headers) {
        this.status = status;
        this.result = result;
        this.headers = headers;
    }

    public HttpStatus getStatus() {
        return this.status;
    }

    public T getResult() {
        return this.result;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }
}

