/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.common.spring;

import com.cybermkd.common.spring.SpringHolder;
import com.cybermkd.common.util.Checker;
import com.cybermkd.common.util.Stringer;
import com.cybermkd.log.Logger;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringBuilder {
    private static final Logger logger = Logger.getLogger(SpringBuilder.class);
    private static ConfigurableApplicationContext context;

    public static ConfigurableApplicationContext getContext() {
        return context;
    }

    public static void setContext(ConfigurableApplicationContext context) {
        Checker.checkNotNull(context, "Could not found context for spring.");
        SpringBuilder.context = context;
        SpringHolder.alive = true;
    }

    public static void refreshContext() {
        if (SpringHolder.alive) {
            context.refresh();
        }
    }

    public static void removeContext() {
        if (SpringHolder.alive) {
            context.close();
            context = null;
            SpringHolder.alive = false;
        }
    }

    public static void register(Class clazz) {
        ConfigurableApplicationContext context = SpringBuilder.getContext();
        if (context != null) {
            DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)context.getBeanFactory();
            String beanName = Stringer.firstLowerCase(clazz.getSimpleName());
            beanFactory.registerBeanDefinition(beanName, (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition((Class)clazz).getBeanDefinition());
        }
    }

    public static void registerSingleton(Class clazz) {
        try {
            SpringBuilder.registerSingleton(clazz, clazz.newInstance());
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), e);
        }
    }

    public static void registerSingleton(Class clazz, Object bean) {
        ConfigurableApplicationContext context = SpringBuilder.getContext();
        if (context != null) {
            DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)context.getBeanFactory();
            String beanName = Stringer.firstLowerCase(clazz.getSimpleName());
            beanFactory.registerSingleton(beanName, bean);
        }
    }

    public static <T> T getBean(Class<T> clazz) {
        ConfigurableApplicationContext context = SpringBuilder.getContext();
        if (context != null) {
            return (T)context.getBean(clazz);
        }
        return null;
    }
}

