/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.common.spring;

import com.cybermkd.common.Plugin;
import com.cybermkd.common.spring.SpringBuilder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringPlugin
implements Plugin {
    private String[] configFiles;
    private Class[] configClasses;
    private ConfigurableApplicationContext context;

    public SpringPlugin() {
        this.configFiles = new String[]{"classpath:applicationContext.xml"};
    }

    public SpringPlugin(String ... configFiles) {
        this.configFiles = configFiles;
    }

    public SpringPlugin(ConfigurableApplicationContext context) {
        this.context = context;
    }

    public SpringPlugin(Class ... configClasses) {
        this.configClasses = configClasses;
    }

    @Override
    public boolean start() {
        if (this.context == null) {
            this.context = this.configFiles == null ? new AnnotationConfigApplicationContext(this.configClasses) : new ClassPathXmlApplicationContext(this.configFiles);
        }
        SpringBuilder.setContext(this.context);
        return true;
    }

    @Override
    public boolean stop() {
        SpringBuilder.removeContext();
        return true;
    }
}

