/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.common.util;

import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.cybermkd.common.http.HttpRequest;
import com.cybermkd.common.http.HttpResponse;
import com.cybermkd.common.util.Checker;
import com.cybermkd.common.util.json.Jsoner;
import java.util.HashMap;
import java.util.Map;

public class Cookier {
    private HttpRequest request;
    private HttpResponse response;
    private Map<String, Object> cookies;

    public Cookier(HttpRequest request) {
        this(request, null);
    }

    public Cookier(HttpResponse response) {
        this(null, response);
    }

    public Cookier(HttpRequest request, HttpResponse response) {
        Checker.checkArgument(request != null || response != null, "You must set request or response.");
        this.request = request;
        this.response = response;
        this.cookies = new HashMap<String, Object>();
    }

    public String get(String name) {
        return this.request.getCookiesMap().get(name);
    }

    public <T> T get(String name, TypeReference<T> type) {
        Object result = null;
        if (this.cookies.containsKey(name)) {
            result = this.cookies.get(name);
        } else {
            Map<String, String> cookieMap = this.request.getCookiesMap();
            if (cookieMap.containsKey(name)) {
                result = Jsoner.toObject(cookieMap.get(name), type, new Feature[0]);
                this.cookies.put(name, result);
            }
        }
        return (T)result;
    }

    public <T> T get(String name, Class<T> clazz) {
        Object result = null;
        if (this.cookies.containsKey(name)) {
            result = this.cookies.get(name);
        } else {
            Map<String, String> cookieMap = this.request.getCookiesMap();
            if (cookieMap.containsKey(name)) {
                result = Jsoner.toObject(cookieMap.get(name), clazz);
                this.cookies.put(name, result);
            }
        }
        return (T)result;
    }

    public void save(String name, Object value, int expiration) {
        String v = value instanceof String ? (String)value : Jsoner.toJSON(value);
        this.response.addCookie(name, v, expiration);
    }
}

