/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.common.util;

import com.cybermkd.common.util.Checker;
import com.cybermkd.common.util.Lister;
import com.cybermkd.common.util.properties.Proper;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class HttpTyper {
    private static final Properties mimeType = Proper.use("mime-types.properties").getProperties();
    private static final String RFC_2616_TOKEN_SPECIAL_CHARS_REGEX = "[\\s\\(\\)<>@,;:\\\\\"/\\[\\]\\?=\\{\\}]";

    public static String getContentTypeFromFileName(String filename) {
        String ext = filename.substring(filename.lastIndexOf(46) + 1);
        return mimeType.getProperty(ext);
    }

    public static String getContentTypeFromExtension(String ext) {
        return mimeType.getProperty(ext);
    }

    public static boolean isTextContentType(String contentType) {
        return contentType.startsWith("text/") || contentType.startsWith("application/json") || contentType.startsWith("application/javascript") || contentType.startsWith("application/ecmascript") || contentType.startsWith("application/atom+xml") || contentType.startsWith("application/rss+xml") || contentType.startsWith("application/xhtml+xml") || contentType.startsWith("application/soap+xml") || contentType.startsWith("application/xml");
    }

    public static String charsetFromContentType(String s) {
        if (!s.contains("charset=")) {
            return null;
        }
        return s.substring(s.indexOf("charset=") + "charset=".length());
    }

    public static String headerTokenCompatible(String s, String specialCharsReplacement) {
        Checker.checkArgument(specialCharsReplacement.replaceAll(RFC_2616_TOKEN_SPECIAL_CHARS_REGEX, "blah").equals(specialCharsReplacement), "specialCharsReplacement `%s` is not itself compatible with rfc 2616 !", specialCharsReplacement);
        return s.replaceAll(RFC_2616_TOKEN_SPECIAL_CHARS_REGEX, specialCharsReplacement);
    }

    static {
        for (String prop : mimeType.stringPropertyNames()) {
            List types = Lister.of(mimeType.getProperty(prop));
            Iterator iterator = types.iterator();
            mimeType.setProperty(prop, iterator.hasNext() ? (String)iterator.next() : "application/octet-stream");
        }
    }
}

