/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.common.util;

public class Stringer {
    private static final char SEPARATOR = '_';

    public static String firstLowerCase(String name) {
        byte[] items = name.getBytes();
        items[0] = (byte)((char)items[0] + 32);
        return new String(items);
    }

    public static String firstUpperCase(String name) {
        byte[] items = name.getBytes();
        items[0] = (byte)((char)items[0] + -32);
        return new String(items);
    }

    public static String underlineCase(String name) {
        if (name == null) {
            return null;
        }
        if (name.contains("_")) {
            return name;
        }
        StringBuilder sb = new StringBuilder();
        boolean upperCase = false;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            boolean nextUpperCase = true;
            if (i < name.length() - 1) {
                nextUpperCase = Character.isUpperCase(name.charAt(i + 1));
            }
            if (i >= 0 && Character.isUpperCase(c)) {
                if (!(upperCase && nextUpperCase || i <= 0)) {
                    sb.append('_');
                }
                upperCase = true;
            } else {
                upperCase = false;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String camelCase(String name) {
        if (name == null) {
            return null;
        }
        if (name.contains("_")) {
            name = name.toLowerCase();
            StringBuilder sb = new StringBuilder(name.length());
            boolean upperCase = false;
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (c == '_') {
                    upperCase = true;
                    continue;
                }
                if (upperCase) {
                    sb.append(Character.toUpperCase(c));
                    upperCase = false;
                    continue;
                }
                sb.append(c);
            }
            return sb.toString();
        }
        return name;
    }

    public static String firstUpperCamelCase(String name) {
        if (name == null) {
            return null;
        }
        name = Stringer.camelCase(name);
        return Stringer.firstUpperCase(name);
    }

    public static boolean isBlank(String str) {
        return str == null || "".equals(str.trim());
    }

    public static boolean notBlank(String str) {
        return str != null && !"".equals(str.trim());
    }

    public static boolean notBlank(String ... strings) {
        if (strings == null) {
            return false;
        }
        for (String str : strings) {
            if (str != null && !"".equals(str.trim())) continue;
            return false;
        }
        return true;
    }

    public static boolean notNull(Object ... paras) {
        if (paras == null) {
            return false;
        }
        for (Object obj : paras) {
            if (obj != null) continue;
            return false;
        }
        return true;
    }
}

