/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.common.util.analysis;

import com.cybermkd.common.util.analysis.ParamAttribute;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ParamNamesScaner {
    public static ParamAttribute getParamNames(Method method) {
        return ParamNamesScaner.getParamNames(method, ParamNamesScaner.getParamNames(method.getDeclaringClass()));
    }

    public static ParamAttribute getParamNames(Method method, Map<String, ParamAttribute> classParamNames) {
        try {
            ParamAttribute paramAttribute = classParamNames.get(ParamNamesScaner.getKey(method));
            int size = method.getParameterTypes().length;
            if (size == 0) {
                paramAttribute.setNames(new ArrayList<String>(0));
            } else {
                paramAttribute.setNames(paramAttribute.getNames().subList(0, size));
            }
            return paramAttribute;
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static ParamAttribute getParamNames(Constructor<?> constructor) {
        return ParamNamesScaner.getParamNames(constructor, ParamNamesScaner.getParamNames(constructor.getDeclaringClass()));
    }

    public static ParamAttribute getParamNames(Constructor<?> constructor, Map<String, ParamAttribute> classParamNames) {
        try {
            ParamAttribute paramAttribute = classParamNames.get(ParamNamesScaner.getKey(constructor));
            int size = constructor.getParameterTypes().length;
            if (size == 0) {
                paramAttribute.setNames(new ArrayList<String>(0));
            } else {
                paramAttribute.setNames(paramAttribute.getNames().subList(0, size));
            }
            return paramAttribute;
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Map<String, ParamAttribute> getParamNames(Class<?> clazz) {
        InputStream in = clazz.getResourceAsStream("/" + clazz.getName().replace('.', '/') + ".class");
        try {
            return ParamNamesScaner.getParamNames(in);
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Map<String, ParamAttribute> getParamNames(InputStream in) throws IOException {
        DataInputStream dis = new DataInputStream(new BufferedInputStream(in));
        HashMap names = new HashMap();
        HashMap<String, int[]> lines = new HashMap<String, int[]>();
        HashMap<Integer, String> strs = new HashMap<Integer, String>();
        dis.skipBytes(4);
        dis.skipBytes(2);
        dis.skipBytes(2);
        int constant_pool_count = dis.readUnsignedShort();
        block12: for (int i = 0; i < constant_pool_count - 1; ++i) {
            byte flag = dis.readByte();
            switch (flag) {
                case 7: {
                    dis.skipBytes(2);
                    continue block12;
                }
                case 9: 
                case 10: 
                case 11: {
                    dis.skipBytes(2);
                    dis.skipBytes(2);
                    continue block12;
                }
                case 8: {
                    dis.skipBytes(2);
                    continue block12;
                }
                case 3: 
                case 4: {
                    dis.skipBytes(4);
                    continue block12;
                }
                case 5: 
                case 6: {
                    dis.skipBytes(8);
                    ++i;
                    continue block12;
                }
                case 12: {
                    dis.skipBytes(2);
                    dis.skipBytes(2);
                    continue block12;
                }
                case 1: {
                    int len = dis.readUnsignedShort();
                    byte[] data = new byte[len];
                    dis.read(data);
                    strs.put(i + 1, new String(data, "UTF-8"));
                    continue block12;
                }
                case 15: {
                    dis.skipBytes(1);
                    dis.skipBytes(2);
                    continue block12;
                }
                case 16: {
                    dis.skipBytes(2);
                    continue block12;
                }
                case 18: {
                    dis.skipBytes(2);
                    dis.skipBytes(2);
                    continue block12;
                }
                default: {
                    throw new RuntimeException("Impossible!! flag=" + flag);
                }
            }
        }
        dis.skipBytes(2);
        dis.skipBytes(2);
        dis.skipBytes(2);
        int interfaces_count = dis.readUnsignedShort();
        dis.skipBytes(2 * interfaces_count);
        int fields_count = dis.readUnsignedShort();
        for (int i = 0; i < fields_count; ++i) {
            dis.skipBytes(2);
            dis.skipBytes(2);
            dis.skipBytes(2);
            int attributes_count = dis.readUnsignedShort();
            for (int j = 0; j < attributes_count; ++j) {
                dis.skipBytes(2);
                int attribute_length = dis.readInt();
                dis.skipBytes(attribute_length);
            }
        }
        int methods_count = dis.readUnsignedShort();
        for (int i = 0; i < methods_count; ++i) {
            dis.skipBytes(2);
            String methodName = (String)strs.get(dis.readUnsignedShort());
            String descriptor = (String)strs.get(dis.readUnsignedShort());
            int attributes_count = dis.readShort();
            for (int j = 0; j < attributes_count; ++j) {
                String attrName = (String)strs.get(dis.readUnsignedShort());
                int attribute_length = dis.readInt();
                if ("Code".equals(attrName)) {
                    dis.skipBytes(2);
                    dis.skipBytes(2);
                    int code_len = dis.readInt();
                    dis.skipBytes(code_len);
                    int exception_table_length = dis.readUnsignedShort();
                    dis.skipBytes(8 * exception_table_length);
                    int code_attributes_count = dis.readUnsignedShort();
                    for (int k = 0; k < code_attributes_count; ++k) {
                        int str_index = dis.readUnsignedShort();
                        String codeAttrName = (String)strs.get(str_index);
                        int code_attribute_length = dis.readInt();
                        if ("LocalVariableTable".equals(codeAttrName)) {
                            int local_variable_table_length = dis.readUnsignedShort();
                            ArrayList<LocalVariable> varNames = new ArrayList<LocalVariable>(local_variable_table_length);
                            for (int l = 0; l < local_variable_table_length; ++l) {
                                dis.skipBytes(2);
                                dis.skipBytes(2);
                                String varName = (String)strs.get(dis.readUnsignedShort());
                                dis.skipBytes(2);
                                int index = dis.readUnsignedShort();
                                if ("this".equals(varName)) continue;
                                varNames.add(new LocalVariable(index, varName));
                            }
                            names.put(methodName + "," + descriptor, varNames);
                            continue;
                        }
                        if ("LineNumberTable".equals(codeAttrName)) {
                            int n = dis.readUnsignedShort();
                            int[] lineNumberTable = new int[n];
                            for (int m = 0; m < n; ++m) {
                                dis.readUnsignedShort();
                                lineNumberTable[m] = dis.readUnsignedShort();
                            }
                            lines.put(methodName + "," + descriptor, lineNumberTable);
                            continue;
                        }
                        dis.skipBytes(code_attribute_length);
                    }
                    continue;
                }
                dis.skipBytes(attribute_length);
            }
        }
        dis.close();
        Set set = names.keySet();
        HashMap<String, ParamAttribute> reMap = new HashMap<String, ParamAttribute>();
        for (String key : set) {
            Object[] tmpArr = ((List)names.get(key)).toArray(new LocalVariable[0]);
            Arrays.sort(tmpArr);
            ArrayList<String> list = new ArrayList<String>();
            for (Object var : tmpArr) {
                list.add(((LocalVariable)var).name);
            }
            reMap.put(key, new ParamAttribute(list, (int[])lines.get(key)));
        }
        return reMap;
    }

    public static String getKey(Object obj) {
        StringBuilder sb = new StringBuilder();
        if (obj instanceof Method) {
            sb.append(((Method)obj).getName()).append(',');
            ParamNamesScaner.getDescriptor(sb, (Method)obj);
        } else if (obj instanceof Constructor) {
            sb.append("<init>,");
            ParamNamesScaner.getDescriptor(sb, (Constructor)obj);
        } else {
            throw new RuntimeException("Not Method or Constructor!");
        }
        return sb.toString();
    }

    public static void getDescriptor(StringBuilder sb, Method method) {
        sb.append('(');
        for (Class<?> klass : method.getParameterTypes()) {
            ParamNamesScaner.getDescriptor(sb, klass);
        }
        sb.append(')');
        ParamNamesScaner.getDescriptor(sb, method.getReturnType());
    }

    public static void getDescriptor(StringBuilder sb, Constructor<?> constructor) {
        sb.append('(');
        for (Class<?> klass : constructor.getParameterTypes()) {
            ParamNamesScaner.getDescriptor(sb, klass);
        }
        sb.append(')');
        sb.append('V');
    }

    public static void getDescriptor(StringBuilder buf, Class<?> c) {
        Class<?> d = c;
        while (true) {
            if (d.isPrimitive()) {
                int car = d == Integer.TYPE ? 73 : (d == Void.TYPE ? 86 : (d == Boolean.TYPE ? 90 : (d == Byte.TYPE ? 66 : (d == Character.TYPE ? 67 : (d == Short.TYPE ? 83 : (d == Double.TYPE ? 68 : (d == Float.TYPE ? 70 : 74)))))));
                buf.append((char)car);
                return;
            }
            if (!d.isArray()) break;
            buf.append('[');
            d = d.getComponentType();
        }
        buf.append('L');
        String name = d.getName();
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char car = name.charAt(i);
            buf.append(car == '.' ? (char)'/' : (char)car);
        }
        buf.append(';');
    }

    static class LocalVariable
    implements Comparable<LocalVariable> {
        public int index;
        public String name;

        public LocalVariable(int index, String name) {
            this.index = index;
            this.name = name;
        }

        @Override
        public int compareTo(LocalVariable o) {
            return this.index - o.index;
        }
    }
}

