/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.common.util.crypto;

import com.cybermkd.common.http.Encoding;
import com.cybermkd.common.util.crypto.CryptoException;
import com.cybermkd.common.util.crypto.Hex;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Cryptor {
    private static List<String> mds = new ArrayList<String>(){
        {
            this.add("MD2");
            this.add("MD5");
        }
    };
    private static List<String> shas = new ArrayList<String>(){
        {
            this.add("SHA-1");
            this.add("SHA-256");
            this.add("SHA-384");
            this.add("SHA-512");
        }
    };
    private static List<String> macs = new ArrayList<String>(){
        {
            this.add("HmacMD5");
            this.add("HmacSHA1");
            this.add("HmacSHA256");
            this.add("HmacSHA384");
            this.add("HmacSHA512");
        }
    };

    public static String crypto(String algorithm, String message) {
        return Cryptor.crypto(algorithm, message, null);
    }

    public static String crypto(String algorithm, String message, String salt) {
        String result;
        if (macs.contains(algorithm)) {
            Mac mac = null;
            try {
                mac = Mac.getInstance(algorithm);
                if (salt == null || salt.isEmpty()) {
                    throw new CryptoException("Could not found secretKey for mac's crypto.");
                }
                SecretKeySpec secretKey = new SecretKeySpec(salt.getBytes(Encoding.UTF_8), algorithm);
                mac.init(secretKey);
            }
            catch (GeneralSecurityException e) {
                throw new CryptoException(e.getMessage(), e);
            }
            result = Hex.encodeHexString(mac.doFinal(message.getBytes(Encoding.UTF_8)));
        } else if (mds.contains(algorithm) || shas.contains(algorithm)) {
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CryptoException(e.getMessage(), e);
            }
            if (salt != null && !salt.isEmpty()) {
                md.update(salt.getBytes(Encoding.UTF_8));
            }
            result = Hex.encodeHexString(md.digest(message.getBytes()));
        } else {
            throw new CryptoException("Could not support this crypto's type " + algorithm + ".");
        }
        return result;
    }
}

