/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.common.util.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.ParseProcess;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimpleDateFormatSerializer;
import com.cybermkd.common.util.json.JsonException;
import java.lang.reflect.Type;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public class Jsoner {
    private static SerializeConfig config = SerializeConfig.getGlobalInstance();
    private static ParserConfig parserConfig = ParserConfig.getGlobalInstance();
    private static SerializerFeature[] serializerFeatures;
    private static Feature[] deserializerFeatures;

    public static void addConfig(Type type, ObjectSerializer serializer, ObjectDeserializer deserializer) {
        Jsoner.addSerializer(type, serializer);
        Jsoner.addDeserializer(type, deserializer);
    }

    public static void addSerializerFeature(SerializerFeature ... features) {
        serializerFeatures = features;
    }

    public static void addDeserializerFeature(Feature ... features) {
        deserializerFeatures = features;
    }

    public static void addSerializer(Type type, ObjectSerializer serializer) {
        config.put((Object)type, (Object)serializer);
    }

    public static void addDeserializer(Type type, ObjectDeserializer deserializer) {
        parserConfig.putDeserializer(type, deserializer);
    }

    public static String toJSON(Object object) {
        if (serializerFeatures != null) {
            return JSON.toJSONString((Object)object, (SerializerFeature[])serializerFeatures);
        }
        return JSON.toJSONString((Object)object);
    }

    public static String toJSON(Object object, SerializerFeature ... features) {
        return JSON.toJSONString((Object)object, (SerializerFeature[])features);
    }

    public static String toJSON(Object object, SerializeFilter[] filters) {
        if (serializerFeatures != null) {
            return JSON.toJSONString((Object)object, (SerializeFilter[])filters, (SerializerFeature[])serializerFeatures);
        }
        return JSON.toJSONString((Object)object, (SerializeFilter[])filters, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static String toJSON(Object object, SerializeFilter[] filters, SerializerFeature ... features) {
        return JSON.toJSONString((Object)object, (SerializeFilter[])filters, (SerializerFeature[])features);
    }

    public static String toJSON(Object object, SerializeConfig config) {
        if (serializerFeatures != null) {
            return JSON.toJSONString((Object)object, (SerializeConfig)config, (SerializerFeature[])serializerFeatures);
        }
        return JSON.toJSONString((Object)object, (SerializeConfig)config, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static String toJSON(Object object, SerializeConfig config, SerializerFeature ... features) {
        return JSON.toJSONString((Object)object, (SerializeConfig)config, (SerializerFeature[])features);
    }

    public static String toJSON(Object object, SerializeConfig config, SerializeFilter filter) {
        if (serializerFeatures != null) {
            return JSON.toJSONString((Object)object, (SerializeConfig)config, (SerializeFilter)filter, (SerializerFeature[])serializerFeatures);
        }
        return JSON.toJSONString((Object)object, (SerializeConfig)config, (SerializeFilter)filter, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static String toJSON(Object object, SerializeConfig config, SerializeFilter filter, SerializerFeature ... features) {
        return JSON.toJSONString((Object)object, (SerializeConfig)config, (SerializeFilter)filter, (SerializerFeature[])features);
    }

    public static <T> T toObject(String json) {
        try {
            return (T)JSON.parse((String)json);
        }
        catch (JSONException e) {
            throw new JsonException("Could not cast \"" + json + "\" to " + JSONObject.class.getName(), e);
        }
    }

    public static <T> T toObject(String json, Class<T> clazz) {
        try {
            if (deserializerFeatures != null) {
                return (T)JSON.parseObject((String)json, clazz, (Feature[])deserializerFeatures);
            }
            return (T)JSON.parseObject((String)json, clazz);
        }
        catch (JSONException e) {
            throw new JsonException("Could not cast \"" + json + "\" to " + clazz.getName(), e);
        }
    }

    public static <T> T toObject(String json, Class<T> clazz, Feature ... features) {
        try {
            return (T)JSON.parseObject((String)json, clazz, (Feature[])features);
        }
        catch (JSONException e) {
            throw new JsonException("Could not cast \"" + json + "\" to " + clazz.getName(), e);
        }
    }

    public static <T> T toObject(String json, Class<T> clazz, ParseProcess processor) {
        try {
            if (deserializerFeatures != null) {
                return (T)JSON.parseObject((String)json, clazz, (ParseProcess)processor, (Feature[])deserializerFeatures);
            }
            return (T)JSON.parseObject((String)json, clazz, (ParseProcess)processor, (Feature[])new Feature[0]);
        }
        catch (JSONException e) {
            throw new JsonException("Could not cast \"" + json + "\" to " + clazz.getName(), e);
        }
    }

    public static <T> T toObject(String json, Class<T> clazz, ParseProcess processor, Feature ... features) {
        try {
            return (T)JSON.parseObject((String)json, clazz, (ParseProcess)processor, (Feature[])features);
        }
        catch (JSONException e) {
            throw new JsonException("Could not cast \"" + json + "\" to " + clazz.getName(), e);
        }
    }

    public static <T> T toObject(String json, TypeReference<T> type, Feature ... features) {
        try {
            return (T)JSON.parseObject((String)json, type, (Feature[])features);
        }
        catch (JSONException e) {
            throw new JsonException("Could not cast \"" + json + "\" to " + type.getClass().getName(), e);
        }
    }

    public static <T> T toObject(String json, Type type) {
        try {
            if (deserializerFeatures != null) {
                return (T)JSON.parseObject((String)json, (Type)type, (Feature[])deserializerFeatures);
            }
            return (T)JSON.parseObject((String)json, (Type)type, (Feature[])new Feature[0]);
        }
        catch (JSONException e) {
            throw new JsonException("Could not cast \"" + json + "\" to " + type.getClass().getName(), e);
        }
    }

    public static <T> T toObject(String json, Type type, Feature ... features) {
        try {
            return (T)JSON.parseObject((String)json, (Type)type, (Feature[])features);
        }
        catch (JSONException e) {
            throw new JsonException("Could not cast \"" + json + "\" to " + type.getClass().getName(), e);
        }
    }

    public static <T> T toObject(String json, Type type, ParseProcess processor) {
        try {
            if (deserializerFeatures != null) {
                return (T)JSON.parseObject((String)json, (Type)type, (ParseProcess)processor, (Feature[])deserializerFeatures);
            }
            return (T)JSON.parseObject((String)json, (Type)type, (ParseProcess)processor, (Feature[])new Feature[0]);
        }
        catch (JSONException e) {
            throw new JsonException("Could not cast \"" + json + "\" to " + type.getClass().getName(), e);
        }
    }

    public static <T> T toObject(String json, Type type, ParseProcess processor, Feature ... features) {
        try {
            return (T)JSON.parseObject((String)json, (Type)type, (ParseProcess)processor, (Feature[])features);
        }
        catch (JSONException e) {
            throw new JsonException("Could not cast \"" + json + "\" to " + type.getClass().getName(), e);
        }
    }

    public static boolean isJson(String source) {
        boolean result = false;
        if (source != null) {
            boolean bl = result = source.startsWith("\"") || source.startsWith("{") || source.startsWith("[");
            if (!result) {
                try {
                    result = JSON.parse((String)source) != null;
                }
                catch (JSONException e) {
                    result = false;
                }
            }
        }
        return result;
    }

    static {
        config.put(Date.class, (Object)new SimpleDateFormatSerializer("yyyy-MM-dd HH:mm:ss"));
        config.put(java.sql.Date.class, (Object)new SimpleDateFormatSerializer("yyyy-MM-dd"));
        config.put(Timestamp.class, (Object)new SimpleDateFormatSerializer("yyyy-MM-dd HH:mm:ss.SSS"));
        config.put(Time.class, (Object)new SimpleDateFormatSerializer("HH:mm:ss"));
    }
}

