/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.common.util.json;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.cybermkd.common.entity.Entity;
import com.cybermkd.common.util.Stringer;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;

public enum ModelSerializer implements ObjectSerializer
{
    INSTANCE;


    public static ModelSerializer instance() {
        return INSTANCE;
    }

    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        if (object == null) {
            serializer.writeNull();
            return;
        }
        if (object instanceof Entity) {
            if (((Entity)object).checkMethod()) {
                Method[] methods = object.getClass().getDeclaredMethods();
                JSONField fieldAnn = null;
                for (Method m : methods) {
                    fieldAnn = m.getAnnotation(JSONField.class);
                    String mName = m.getName();
                    if (fieldAnn != null && !fieldAnn.serialize() || m.getParameterTypes().length != 0 || mName.length() <= 3 || !mName.startsWith("get") || this.hasMethod((Entity)object, mName)) continue;
                    try {
                        m.invoke(object, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new JSONException("Method could not invoke.", (Throwable)e);
                    }
                }
            }
            serializer.write(((Entity)object).getAttrs());
        }
    }

    private boolean hasMethod(Entity object, String mName) {
        String name;
        Map<String, Object> attrs = object.getAttrs();
        return attrs.containsKey(Stringer.firstLowerCase(name = mName.replace("get", ""))) || attrs.containsKey(Stringer.underlineCase(name));
    }
}

