/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.common.util.properties;

import com.cybermkd.common.Constant;
import com.cybermkd.log.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

public class Prop {
    private static final Logger logger = Logger.getLogger(Prop.class);
    private Properties properties = null;
    private static String rootClassPath = null;

    public Prop(String fileName) {
        this(fileName, Constant.encoding);
    }

    public Prop(String fileName, String encoding) {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
        this.load(fileName, inputStream, encoding);
    }

    public Prop(File file) {
        this(file, Constant.encoding);
    }

    public Prop(File file, String encoding) {
        if (file == null) {
            throw new IllegalArgumentException("File can not be null.");
        }
        String fileName = file.getName();
        if (!file.isFile()) {
            throw new IllegalArgumentException("Not a file : " + fileName);
        }
        try {
            FileInputStream inputStream = new FileInputStream(file);
            this.load(fileName, inputStream, encoding);
        }
        catch (FileNotFoundException e) {
            logger.warn(e.getMessage(), e);
        }
    }

    void load(String fileName, InputStream inputStream, String encoding) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Properties file not found in classpath: " + fileName);
        }
        try {
            this.properties = new Properties();
            this.properties.load(new InputStreamReader(inputStream, encoding == null ? "UTF-8" : encoding));
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading properties file.", e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                logger.warn(e.getMessage(), e);
            }
        }
    }

    public String get(String key) {
        return this.properties.getProperty(key);
    }

    public String get(String key, String defaultValue) {
        String value = this.get(key);
        return value != null ? value : defaultValue;
    }

    public Integer getInt(String key) {
        String value = this.get(key);
        return value != null ? Integer.valueOf(Integer.parseInt(value)) : null;
    }

    public Integer getInt(String key, Integer defaultValue) {
        String value = this.get(key);
        return value != null ? Integer.parseInt(value) : defaultValue;
    }

    public Long getLong(String key) {
        String value = this.get(key);
        return value != null ? Long.valueOf(Long.parseLong(value)) : null;
    }

    public Long getLong(String key, Long defaultValue) {
        String value = this.get(key);
        return value != null ? Long.parseLong(value) : defaultValue;
    }

    public Boolean getBoolean(String key) {
        String value = this.get(key);
        return value != null ? Boolean.valueOf(Boolean.parseBoolean(value)) : null;
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        String value = this.get(key);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public static String getRootClassPath() {
        if (rootClassPath == null) {
            try {
                String path = Prop.class.getClassLoader().getResource("").toURI().getPath();
                rootClassPath = new File(path).getAbsolutePath();
            }
            catch (Exception e) {
                String path = Prop.class.getClassLoader().getResource("").getPath();
                rootClassPath = new File(path).getAbsolutePath();
            }
        }
        return rootClassPath;
    }
}

