/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.common.util.properties;

import com.cybermkd.common.Constant;
import com.cybermkd.common.util.properties.Prop;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Proper {
    private static final Map<String, Prop> map = new ConcurrentHashMap<String, Prop>();
    private static Prop prop = null;

    private Proper() {
    }

    public static Prop use(String fileName) {
        return Proper.use(fileName, Constant.encoding);
    }

    public static Prop use(String fileName, String encoding) {
        Prop result = map.get(fileName);
        if (result == null) {
            result = new Prop(fileName, encoding);
            map.put(fileName, result);
            if (prop == null) {
                prop = result;
            }
        }
        return result;
    }

    public static Prop use(File file) {
        return Proper.use(file, Constant.encoding);
    }

    public static Prop use(File file, String encoding) {
        Prop result = map.get(file.getName());
        if (result == null) {
            result = new Prop(file, encoding);
            map.put(file.getName(), result);
            if (prop == null) {
                prop = result;
            }
        }
        return result;
    }

    public static Prop useless(String fileName) {
        Prop previous = map.remove(fileName);
        if (prop == previous) {
            prop = null;
        }
        return previous;
    }

    public static void clear() {
        prop = null;
        map.clear();
    }

    public static Prop getProp() {
        if (prop == null) {
            throw new IllegalStateException("Load propties file by invoking Proper.use(String fileName) method first.");
        }
        return prop;
    }

    public static Prop getProp(String fileName) {
        return map.get(fileName);
    }

    public static String get(String key) {
        return Proper.getProp().get(key);
    }

    public static String get(String key, String defaultValue) {
        return Proper.getProp().get(key, defaultValue);
    }

    public static Integer getInt(String key) {
        return Proper.getProp().getInt(key);
    }

    public static Integer getInt(String key, Integer defaultValue) {
        return Proper.getProp().getInt(key, defaultValue);
    }

    public static Long getLong(String key) {
        return Proper.getProp().getLong(key);
    }

    public static Long getLong(String key, Long defaultValue) {
        return Proper.getProp().getLong(key, defaultValue);
    }

    public static Boolean getBoolean(String key) {
        return Proper.getProp().getBoolean(key);
    }

    public static Boolean getBoolean(String key, Boolean defaultValue) {
        return Proper.getProp().getBoolean(key, defaultValue);
    }

    public static boolean containsKey(String key) {
        return Proper.getProp().containsKey(key);
    }
}

