/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.common.util.scan;

import com.cybermkd.common.http.Encoding;
import com.cybermkd.common.util.Checker;
import com.cybermkd.common.util.scan.ScanException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public abstract class Scaner {
    protected Set<String> includePackages = new HashSet<String>();

    public abstract boolean checkTarget(Class<?> var1);

    public <T> Set<Class<? extends T>> scan() {
        HashSet<Class<T>> classSet = new HashSet<Class<T>>();
        if (this.includePackages.size() > 0) {
            HashSet<String> classFileSet = new HashSet<String>();
            for (String classpath : this.includePackages) {
                classFileSet.addAll(this.findFiles(classpath, "*.class"));
            }
            for (String classFile : classFileSet) {
                Class<?> classInFile = null;
                try {
                    classInFile = Thread.currentThread().getContextClassLoader().loadClass(classFile);
                }
                catch (ClassNotFoundException e) {
                    throw new ScanException(e.getMessage(), e);
                }
                if (!this.checkTarget(classInFile)) continue;
                classSet.add(classInFile);
            }
        }
        return classSet;
    }

    protected Set<String> findFiles(String baseDirName, String targetFileName) {
        HashSet<String> classFiles = new HashSet<String>();
        Enumeration<URL> baseURLs = null;
        try {
            baseURLs = Scaner.class.getClassLoader().getResources(baseDirName.replaceAll("\\.", "/"));
        }
        catch (IOException e) {
            throw new ScanException(e.getMessage(), e);
        }
        URL baseURL = null;
        while (baseURLs.hasMoreElements()) {
            baseURL = baseURLs.nextElement();
            if (baseURL == null) continue;
            String protocol = baseURL.getProtocol();
            String basePath = baseURL.getFile();
            if ("jar".equals(protocol)) {
                String[] paths = basePath.split("!/");
                try {
                    classFiles.addAll(this.findJarFile(URLDecoder.decode(paths[0].replace("file:", ""), Encoding.UTF_8.name()), paths[1]));
                    continue;
                }
                catch (IOException e) {
                    throw new ScanException(e.getMessage(), e);
                }
            }
            classFiles.addAll(this.findPackageFiles(basePath, targetFileName));
        }
        return classFiles;
    }

    private Set<String> findPackageFiles(String baseDirName, String targetFileName) {
        HashSet<String> classFiles = new HashSet<String>();
        String tempName = null;
        File baseDir = null;
        try {
            baseDir = new File(URLDecoder.decode(baseDirName, Encoding.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new ScanException(e.getMessage(), e);
        }
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            throw new ScanException("Search error : " + baseDirName + " is not a dir.");
        }
        String[] filelist = baseDir.list();
        String classname = null;
        String tem = null;
        for (String aFilelist : filelist) {
            File readfile = null;
            try {
                readfile = new File(URLDecoder.decode(baseDirName + File.separator + aFilelist, Encoding.UTF_8.name()));
            }
            catch (UnsupportedEncodingException e) {
                throw new ScanException(e.getMessage(), e);
            }
            if (readfile.isDirectory()) {
                classFiles.addAll(this.findPackageFiles(baseDirName + File.separator + aFilelist, targetFileName));
                continue;
            }
            tempName = readfile.getName();
            if (!this.wildcardMatch(targetFileName, tempName)) continue;
            tem = readfile.getAbsoluteFile().toString().replaceAll("\\\\", "/");
            classname = tem.substring(tem.indexOf("classes/") + "classes/".length(), tem.indexOf(".class"));
            classFiles.add(classname.replaceAll("/", "."));
        }
        return classFiles;
    }

    private boolean wildcardMatch(String pattern, String str) {
        int patternLength = pattern.length();
        int strLength = str.length();
        int strIndex = 0;
        for (int patternIndex = 0; patternIndex < patternLength; ++patternIndex) {
            char ch = pattern.charAt(patternIndex);
            if (ch == '*') {
                while (strIndex < strLength) {
                    if (this.wildcardMatch(pattern.substring(patternIndex + 1), str.substring(strIndex))) {
                        return true;
                    }
                    ++strIndex;
                }
                continue;
            }
            if (ch == '?') {
                if (++strIndex <= strLength) continue;
                return false;
            }
            if (strIndex >= strLength || ch != str.charAt(strIndex)) {
                return false;
            }
            ++strIndex;
        }
        return strIndex == strLength;
    }

    private Set<String> findJarFile(String filePath, String packageName) throws IOException {
        JarFile localJarFile = new JarFile(new File(filePath));
        Set<String> classFiles = this.findInJar(localJarFile, packageName);
        localJarFile.close();
        return classFiles;
    }

    private Set<String> findInJar(JarFile localJarFile, String packageName) {
        HashSet<String> classFiles = new HashSet<String>();
        Enumeration<JarEntry> entries = localJarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            String entryName = jarEntry.getName();
            if (jarEntry.isDirectory() || packageName != null && !entryName.startsWith(packageName) || !entryName.endsWith(".class")) continue;
            String className = entryName.replaceAll("/", ".").substring(0, entryName.length() - 6);
            classFiles.add(className);
        }
        return classFiles;
    }

    public Scaner includePackages(String ... classPackages) {
        Checker.checkNotNull(classPackages, "Class packages could not be null.");
        Collections.addAll(this.includePackages, classPackages);
        return this;
    }

    public Scaner includePackages(Set<String> classPackages) {
        Checker.checkNotNull(classPackages, "Class packages could not be null.");
        for (String classpath : classPackages) {
            this.includePackages.add(classpath);
        }
        return this;
    }

    private Set<String> findjarFiles(String baseDirName, final Set<String> includeJars, String packageName) {
        HashSet<String> classFiles = new HashSet<String>();
        try {
            String[] filelist;
            File baseDir = new File(URLDecoder.decode(baseDirName, Encoding.UTF_8.name()));
            if (!baseDir.exists() || !baseDir.isDirectory()) {
                throw new ScanException("Jar file scan error : " + baseDirName + " is not a dir.");
            }
            for (String aFilelist : filelist = baseDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return includeJars.contains(name);
                }
            })) {
                classFiles.addAll(this.findJarFile(baseDirName + File.separator + aFilelist, packageName));
            }
        }
        catch (IOException e) {
            throw new ScanException(e.getMessage(), e);
        }
        return classFiles;
    }
}

