/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.common.util.stream;

import com.cybermkd.common.Constant;
import com.cybermkd.common.util.stream.DefaultFileRenamer;
import com.cybermkd.log.Logger;
import java.io.File;
import java.io.IOException;

public abstract class FileRenamer {
    public static final FileRenamer RENAMER;
    private static final Logger logger;

    public abstract File rename(File var1);

    protected boolean createNewFile(File f) {
        try {
            return f.createNewFile();
        }
        catch (IOException ignored) {
            return false;
        }
    }

    static {
        logger = Logger.getLogger(FileRenamer.class);
        FileRenamer fileRenamer = null;
        if (Constant.fileRenamer == null) {
            fileRenamer = new DefaultFileRenamer();
        } else {
            try {
                Class<?> renameClass = Class.forName(Constant.fileRenamer);
                fileRenamer = (FileRenamer)renameClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                logger.error("Could not found FileRenamer Class.", e);
            }
            catch (InstantiationException e) {
                logger.error("Could not init FileRenamer Class.", e);
            }
            catch (IllegalAccessException e) {
                logger.error("Could not access FileRenamer Class.", e);
            }
        }
        RENAMER = fileRenamer;
    }
}

