/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.common.util.stream;

import com.cybermkd.common.util.stream.FileException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class Filer {
    public static File mkDirs(String path) {
        return Filer.mkDirs(new File(path));
    }

    public static File mkDirs(File file) {
        if (file == null) {
            throw new FileException("File could not be null.");
        }
        File parent = file.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new FileException("Directory " + parent.getAbsolutePath() + " not exists and can not create directory.");
        }
        return file;
    }

    public static boolean exist(String file) {
        Enumeration<URL> urls = null;
        try {
            urls = Thread.currentThread().getContextClassLoader().getResources(file);
            if (urls.hasMoreElements()) {
                return true;
            }
        }
        catch (IOException e) {
            throw new FileException("Could not getResource from file - " + file, e);
        }
        return false;
    }

    public static List<File> files(String dir) {
        return Filer.files(new File(dir));
    }

    public static List<File> files(File dir) {
        File[] files;
        ArrayList<File> result = new ArrayList<File>();
        if (dir.exists() && (files = dir.listFiles()) != null && files.length > 0) {
            for (File file : files) {
                if (file.isHidden()) continue;
                if (file.isDirectory()) {
                    result.addAll(Filer.files(new File(file.getAbsolutePath())));
                    continue;
                }
                result.add(file);
            }
        }
        return result;
    }
}

