/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.common.util.stream;

import com.cybermkd.common.Constant;
import com.cybermkd.common.util.stream.FileRenamer;
import com.cybermkd.common.util.stream.Filer;
import com.cybermkd.log.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class StreamReader {
    private static final Logger logger = Logger.getLogger(StreamReader.class);

    public static String readString(InputStream is) throws IOException {
        return StreamReader.readString(is, Constant.encoding);
    }

    public static String readString(InputStream is, String encoding) throws IOException {
        String result = null;
        if (is != null) {
            String line;
            BufferedReader rd = new BufferedReader(new InputStreamReader(is, encoding));
            StringBuilder response = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                response.append(line);
            }
            result = response.toString();
            logger.debug("Read stream from inputStream: %s", result);
            rd.close();
        }
        return result;
    }

    public static File readFile(InputStream is, File writeFile) throws IOException {
        return StreamReader.readFile(is, writeFile, null);
    }

    public static File readFile(InputStream is, int contentLength, File writeFile) throws IOException {
        return StreamReader.readFile(is, contentLength, writeFile, null);
    }

    public static File readFile(InputStream is, File writeFile, FileRenamer renamer) throws IOException {
        File file = null;
        if (is != null) {
            file = renamer != null ? renamer.rename(writeFile) : Filer.mkDirs(writeFile);
            FileOutputStream out = new FileOutputStream(file);
            byte[] buffer = new byte[4096];
            int len = -1;
            while ((len = is.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, len);
            }
            ((OutputStream)out).close();
        }
        return file;
    }

    public static File readFile(InputStream is, int contentLength, File writeFile, FileRenamer renamer) throws IOException {
        File file = null;
        if (is != null) {
            if (renamer == null && writeFile.exists()) {
                if (contentLength == 0) {
                    logger.warn("File download was complete, don't download " + writeFile.getPath());
                    return writeFile;
                }
                long start = writeFile.length();
                RandomAccessFile out = new RandomAccessFile(writeFile, "rw");
                out.seek(start);
                byte[] buffer = new byte[1024];
                int len = -1;
                while ((len = is.read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
                out.close();
                file = writeFile;
            } else {
                file = StreamReader.readFile(is, writeFile, renamer);
            }
        }
        return file;
    }
}

