/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.filter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.zip.GZIPOutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class GzipFilter
implements Filter {
    private String encoding;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.encoding = "UTF-8";
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest requ = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        MyHttpServletResponseWrapper myresponse = new MyHttpServletResponseWrapper(resp);
        chain.doFilter((ServletRequest)requ, (ServletResponse)myresponse);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzipout = new GZIPOutputStream(baos);
        byte[] b = myresponse.getOldBytes();
        gzipout.write(b);
        gzipout.close();
        b = baos.toByteArray();
        resp.setHeader("content-encoding", "gzip");
        resp.setContentLength(b.length);
        resp.getOutputStream().write(b);
    }

    public void destroy() {
    }

    private class ZipStream
    extends ServletOutputStream {
        private OutputStream baos;

        public ZipStream(OutputStream baos) {
            this.baos = baos;
        }

        public void write(int b) throws IOException {
            this.baos.write(b);
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }

    private class MyHttpServletResponseWrapper
    extends HttpServletResponseWrapper {
        private HttpServletResponse response;
        private ByteArrayOutputStream baos;
        private PrintWriter pw;

        public MyHttpServletResponseWrapper(HttpServletResponse response) {
            super(response);
            this.baos = new ByteArrayOutputStream();
            this.response = response;
        }

        public byte[] getOldBytes() {
            if (this.pw != null) {
                this.pw.close();
            }
            return this.baos.toByteArray();
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return new ZipStream(this.baos);
        }

        public PrintWriter getWriter() throws IOException {
            this.pw = new PrintWriter(new OutputStreamWriter((OutputStream)this.baos, GzipFilter.this.encoding));
            return this.pw;
        }
    }
}

