/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.log.provider;

import com.cybermkd.common.util.Colorer;
import com.cybermkd.log.Logger;
import com.cybermkd.log.provider.LoggerProvider;
import java.util.logging.Level;

public class JdkLoggerProvider
implements LoggerProvider {
    @Override
    public Logger getLogger(Class clazz) {
        return new JdkLogger(java.util.logging.Logger.getLogger(clazz.getName()));
    }

    @Override
    public Logger getLogger(String clazzName) {
        return new JdkLogger(java.util.logging.Logger.getLogger(clazzName));
    }

    public class JdkLogger
    extends Logger {
        private java.util.logging.Logger logger;
        private String clazzName;

        JdkLogger(java.util.logging.Logger logger) {
            this.logger = logger;
        }

        @Override
        public void debug(String message) {
            this.logger.logp(Level.FINE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), Colorer.cyan(message));
        }

        @Override
        public void debug(String message, Throwable t) {
            this.logger.logp(Level.FINE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), Colorer.cyan(message), t);
        }

        @Override
        public void debug(String message, Object ... args) {
            this.logger.logp(Level.FINE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), Colorer.cyan(String.format(message, args)));
        }

        @Override
        public void debug(String message, Throwable t, Object ... args) {
            this.logger.logp(Level.FINE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), Colorer.cyan(String.format(message, args)), t);
        }

        @Override
        public void info(String message) {
            this.logger.logp(Level.INFO, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), Colorer.blue(message));
        }

        @Override
        public void info(String message, Throwable t) {
            this.logger.logp(Level.INFO, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), Colorer.blue(message), t);
        }

        @Override
        public void info(String message, Object ... args) {
            this.logger.logp(Level.INFO, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), Colorer.blue(String.format(message, args)));
        }

        @Override
        public void info(String message, Throwable t, Object ... args) {
            this.logger.logp(Level.INFO, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), Colorer.blue(String.format(message, args)), t);
        }

        @Override
        public void warn(String message) {
            this.logger.logp(Level.WARNING, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), Colorer.yellow(message));
        }

        @Override
        public void warn(String message, Throwable t) {
            this.logger.logp(Level.WARNING, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), Colorer.yellow(message), t);
        }

        @Override
        public void warn(String message, Object ... args) {
            this.logger.logp(Level.WARNING, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), Colorer.yellow(String.format(message, args)));
        }

        @Override
        public void warn(String message, Throwable t, Object ... args) {
            this.logger.logp(Level.WARNING, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), Colorer.yellow(String.format(message, args)), t);
        }

        @Override
        public void error(String message) {
            this.logger.logp(Level.SEVERE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), Colorer.red(message));
        }

        @Override
        public void error(String message, Throwable t) {
            this.logger.logp(Level.SEVERE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), Colorer.red(message), t);
        }

        @Override
        public void error(String message, Object ... args) {
            this.logger.logp(Level.SEVERE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), Colorer.red(String.format(message, args)));
        }

        @Override
        public void error(String message, Throwable t, Object ... args) {
            this.logger.logp(Level.SEVERE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), Colorer.red(String.format(message, args)), t);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isLoggable(Level.FINE);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isLoggable(Level.INFO);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isLoggable(Level.WARNING);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.logger.isLoggable(Level.SEVERE);
        }
    }
}

