/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.route;

import com.cybermkd.common.Plugin;
import com.cybermkd.route.config.Config;
import com.cybermkd.route.config.ConstantLoader;
import com.cybermkd.route.config.HandlerLoader;
import com.cybermkd.route.config.InterceptorLoader;
import com.cybermkd.route.config.PluginLoader;
import com.cybermkd.route.config.ResourceLoader;
import com.cybermkd.route.exception.PluginException;
import java.util.List;

public class ConfigIniter {
    private static final ConstantLoader CONSTANT_LOADER = new ConstantLoader();
    private static final ResourceLoader RESOURCE_LOADER = new ResourceLoader();
    private static final PluginLoader PLUGIN_LOADER = new PluginLoader();
    private static final InterceptorLoader INTERCEPTOR_LOADER = new InterceptorLoader();
    private static final HandlerLoader HANDLER_LOADER = new HandlerLoader();

    public ConfigIniter(Config config) {
        config.configConstant(CONSTANT_LOADER);
        config.configPlugin(PLUGIN_LOADER);
        this.startPlugins();
        config.configResource(RESOURCE_LOADER);
        this.buildRrsource();
        config.configInterceptor(INTERCEPTOR_LOADER);
        config.configHandler(HANDLER_LOADER);
    }

    public ConstantLoader getConstantLoader() {
        return CONSTANT_LOADER;
    }

    public ResourceLoader getResourceLoader() {
        return RESOURCE_LOADER;
    }

    public PluginLoader getPluginLoader() {
        return PLUGIN_LOADER;
    }

    public InterceptorLoader getInterceptorLoader() {
        return INTERCEPTOR_LOADER;
    }

    public HandlerLoader getHandlerLoader() {
        return HANDLER_LOADER;
    }

    public void buildRrsource() {
        RESOURCE_LOADER.build();
    }

    public void startPlugins() {
        List<Plugin> plugins = PLUGIN_LOADER.getPlugins();
        if (plugins != null) {
            for (Plugin plugin : plugins) {
                if (plugin.start()) continue;
                throw new PluginException("Plugin start error: " + plugin.getClass().getName());
            }
        }
    }

    public void stopPlugins() {
        List<Plugin> plugins = PLUGIN_LOADER.getPlugins();
        if (plugins != null) {
            for (Plugin plugin : plugins) {
                if (plugin.stop()) continue;
                throw new PluginException("Plugin stop error: " + plugin.getClass().getName());
            }
        }
    }
}

