/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.route;

import com.cybermkd.common.Constant;
import com.cybermkd.common.http.HttpRequest;
import com.cybermkd.common.http.HttpResponse;
import com.cybermkd.common.util.matcher.AntPathMatcher;
import com.cybermkd.log.Logger;
import com.cybermkd.route.ICEREST;
import com.cybermkd.route.IceIniter;
import com.cybermkd.route.config.Config;
import com.cybermkd.route.exception.InitException;
import com.cybermkd.route.handler.Handler;
import com.cybermkd.route.holder.ExceptionHolder;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class IceFilter
implements Filter {
    public static final String PARAM_NAME_CONFIGCLASS = "configClass";
    public static final String PARAM_NAME_EXCLUSIONS = "exclusions";
    private static final Logger logger = Logger.getLogger(IceFilter.class);
    private IceIniter iceIniter;
    private Handler handler;
    private String encoding = Constant.encoding;
    private Set<String> excludesPattern;
    private static final ICEREST icerest = ICEREST.me();

    public void init(FilterConfig filterConfig) throws ServletException {
        String exclusions = filterConfig.getInitParameter(PARAM_NAME_EXCLUSIONS);
        if (exclusions != null && exclusions.trim().length() != 0) {
            this.excludesPattern = new HashSet<String>(Arrays.asList(exclusions.split("\\s*,\\s*")));
        }
        try {
            Config config = this.createConfig(filterConfig.getInitParameter(PARAM_NAME_CONFIGCLASS));
            if (!icerest.init(config, filterConfig.getServletContext())) {
                throw new RuntimeException("ICEREST init error!");
            }
            this.iceIniter = icerest.getRestIniter();
            this.handler = this.iceIniter.getHandler();
            logger.info("==========================================================================================================");
            logger.info("Initialization completed\uff0cplease enjoy the High speed development experience (\u3065\uffe3 3\uffe3)\u3065 ");
            logger.info("==========================================================================================================");
        }
        catch (Exception e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isExclusion(String requestURI) {
        if (this.excludesPattern == null) {
            return false;
        }
        for (String pattern : this.excludesPattern) {
            if (!AntPathMatcher.instance().matches(pattern, requestURI)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            throw new ServletException("ICEREST doesn't support non-HTTP request or response.");
        }
        servletRequest.setCharacterEncoding(this.encoding);
        servletResponse.setCharacterEncoding(this.encoding);
        HttpRequest request = new HttpRequest((HttpServletRequest)servletRequest, this.iceIniter.getServletContext());
        HttpResponse response = new HttpResponse((HttpServletResponse)servletResponse, (HttpServletRequest)servletRequest);
        boolean[] isHandled = new boolean[]{false};
        if (!this.isExclusion(request.getRestPath())) {
            try {
                this.handler.handle(request, response, isHandled);
            }
            catch (Exception e) {
                ExceptionHolder.HOLDER.hold(request, response, e, isHandled);
            }
            finally {
                response.close();
            }
        }
        if (!isHandled[0]) {
            chain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
        try {
            this.iceIniter.stop();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Config createConfig(String configClass) {
        Config config = null;
        if (configClass != null) {
            Object temp = null;
            try {
                temp = Class.forName(configClass).newInstance();
            }
            catch (Exception e) {
                throw new InitException("Could not create instance of class: " + configClass, e);
            }
            if (!(temp instanceof Config)) throw new InitException("Could not create instance of class: " + configClass + ". Please check the init in web.xml");
            return temp;
        }
        config = new Config();
        logger.warn("Could not found init and start in no init.");
        return config;
    }
}

