/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.route.config;

import com.cybermkd.common.util.scan.ClassScaner;
import com.cybermkd.log.Logger;
import com.cybermkd.route.core.Resource;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class ResourceLoader {
    private static final Logger logger = Logger.getLogger(ResourceLoader.class);
    private final Set<Class<? extends Resource>> resources = new HashSet<Class<? extends Resource>>();
    private Set<Class<? extends Resource>> excludeResources = new HashSet<Class<? extends Resource>>();
    private Set<Class<? extends Resource>> includeResources = new HashSet<Class<? extends Resource>>();
    private Set<String> includeResourcePackages = new HashSet<String>();
    private Set<String> excludeResourcePackages = new HashSet<String>();

    public ResourceLoader add(ResourceLoader resourceLoader) {
        if (resourceLoader != null) {
            resourceLoader.build();
            this.resources.addAll(resourceLoader.resources);
        }
        return this;
    }

    public ResourceLoader add(Class<? extends Resource> resourceClass) {
        this.resources.add(resourceClass);
        return this;
    }

    public ResourceLoader addExcludeClasses(Class<? extends Resource> ... clazzes) {
        Collections.addAll(this.excludeResources, clazzes);
        return this;
    }

    public ResourceLoader addExcludeClasses(Set<Class<? extends Resource>> clazzes) {
        if (clazzes != null) {
            this.excludeResources.addAll(clazzes);
        }
        return this;
    }

    public ResourceLoader addExcludePackages(String ... packages) {
        Collections.addAll(this.excludeResourcePackages, packages);
        return this;
    }

    public ResourceLoader addIncludeClasses(Class<? extends Resource> ... clazzes) {
        Collections.addAll(this.includeResources, clazzes);
        return this;
    }

    public ResourceLoader addIncludeClasses(Set<Class<? extends Resource>> clazzes) {
        if (clazzes != null) {
            this.includeResources.addAll(clazzes);
        }
        return this;
    }

    public ResourceLoader addIncludePackages(String ... packages) {
        Collections.addAll(this.includeResourcePackages, packages);
        return this;
    }

    public void build() {
        if (this.includeResourcePackages.size() > 0) {
            if (this.includeResources.size() <= 0) {
                this.includeResources = ClassScaner.of(Resource.class).includePackages(this.includeResourcePackages).scan();
            } else {
                this.includeResources.addAll(ClassScaner.of(Resource.class).includePackages(this.includeResourcePackages).scan());
            }
        }
        boolean isExclude = false;
        if (this.includeResources.size() > 0) {
            for (Class<? extends Resource> resource : this.includeResources) {
                isExclude = false;
                if (this.excludeResourcePackages.size() > 0) {
                    for (String excludepath : this.excludeResourcePackages) {
                        if (!resource.getName().startsWith(excludepath)) continue;
                        logger.debug("Exclude resource:" + resource.getName());
                        isExclude = true;
                        break;
                    }
                }
                if (isExclude || this.excludeResources.contains(resource)) continue;
                this.add(resource);
                logger.info("Resources.add(" + resource.getName() + ")");
            }
        } else {
            logger.warn("Could not load any resources.");
        }
    }

    public Set<Class<? extends Resource>> getResources() {
        return this.resources;
    }
}

