/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.route.core;

import com.alibaba.fastjson.JSONObject;
import com.cybermkd.common.Constant;
import com.cybermkd.common.entity.Entity;
import com.cybermkd.common.http.ContentType;
import com.cybermkd.common.http.HttpRequest;
import com.cybermkd.common.http.HttpResponse;
import com.cybermkd.common.http.UploadedFile;
import com.cybermkd.common.http.exception.WebException;
import com.cybermkd.common.http.result.HttpStatus;
import com.cybermkd.common.util.Checker;
import com.cybermkd.common.util.Joiner;
import com.cybermkd.common.util.analysis.ParamAttribute;
import com.cybermkd.common.util.analysis.ParamNamesScaner;
import com.cybermkd.common.util.json.Jsoner;
import com.cybermkd.common.util.json.ModelDeserializer;
import com.cybermkd.common.util.stream.StreamReader;
import com.cybermkd.log.Logger;
import com.cybermkd.route.core.Params;
import com.cybermkd.route.core.Resource;
import com.cybermkd.route.core.RouteInvocation;
import com.cybermkd.route.core.RouteMatch;
import com.cybermkd.route.core.multipart.MultipartBuilder;
import com.cybermkd.route.core.multipart.MultipartParam;
import com.cybermkd.route.exception.InitException;
import com.cybermkd.route.interceptor.Interceptor;
import com.cybermkd.route.render.RenderFactory;
import com.cybermkd.route.valid.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Route {
    public static final String PARAM_PATTERN = "([^\\/]+)";
    private static final Logger logger = Logger.getLogger(Route.class);
    private static final PathParserCharProcessor regularCharPathParserCharProcessor = new PathParserCharProcessor(){

        @Override
        public void handle(int curChar, PathPatternParser pathPatternParser) {
            if (curChar == 123) {
                pathPatternParser.processor = new CurlyBracesPathParamPathParserCharProcessor();
            } else if (curChar == 58) {
                pathPatternParser.processor = new SimpleColumnBasedPathParamParserCharProcessor();
            } else {
                pathPatternParser.patternBuilder.appendCodePoint(curChar);
                pathPatternParser.stdPathPatternBuilder.appendCodePoint(curChar);
            }
        }

        @Override
        public void end(PathPatternParser pathPatternParser) {
        }
    };
    private final String httpMethod;
    private final String pathPattern;
    private final String stdPathPattern;
    private final Pattern pattern;
    private final List<String> pathParamNames;
    private final Class<? extends Resource> resourceClass;
    private final Method method;
    private final List<String> allParamNames;
    private final int[] allLineNumbers;
    private final List<Class<?>> allParamTypes;
    private final List<Type> allGenericParamTypes;
    private final Interceptor[] interceptors;
    private final int[][] interceptorsLineNumbers;
    private final Validator[] validators;
    private final int[][] validsLineNumbers;
    private final MultipartBuilder multipartBuilder;
    private final Map<String, String> headers;

    public Route(Class<? extends Resource> resourceClass, ParamAttribute paramAttribute, String httpMethod, String pathPattern, Method method, Interceptor[] interceptors, String des, Validator[] validators, MultipartBuilder multipartBuilder, Map<String, String> headers) {
        this.resourceClass = resourceClass;
        this.httpMethod = Checker.checkNotNull(httpMethod);
        this.pathPattern = Checker.checkNotNull(pathPattern);
        this.method = method;
        this.multipartBuilder = multipartBuilder;
        this.interceptors = interceptors;
        this.allParamNames = paramAttribute.getNames();
        this.allLineNumbers = paramAttribute.getLines();
        this.allParamTypes = Arrays.asList(method.getParameterTypes());
        this.allGenericParamTypes = Arrays.asList(method.getGenericParameterTypes());
        this.validators = validators;
        this.headers = headers;
        if (Constant.showRoute) {
            ParamAttribute paramAttr;
            this.interceptorsLineNumbers = new int[interceptors.length][];
            int i = 0;
            for (Interceptor interceptor : interceptors) {
                try {
                    paramAttr = ParamNamesScaner.getParamNames(interceptor.getClass().getMethod("intercept", RouteInvocation.class));
                }
                catch (NoSuchMethodException e) {
                    throw new InitException(e.getMessage(), e);
                }
                this.interceptorsLineNumbers[i] = paramAttr.getLines();
                ++i;
            }
            this.validsLineNumbers = new int[validators.length][];
            i = 0;
            for (Validator validator : validators) {
                try {
                    paramAttr = ParamNamesScaner.getParamNames(validator.getClass().getMethod("validate", Params.class, RouteMatch.class));
                }
                catch (NoSuchMethodException e) {
                    throw new InitException(e.getMessage(), e);
                }
                this.validsLineNumbers[i] = paramAttr.getLines();
                ++i;
            }
        } else {
            this.validsLineNumbers = null;
            this.interceptorsLineNumbers = null;
        }
        PathPatternParser s = new PathPatternParser(pathPattern);
        s.parse();
        this.pattern = Pattern.compile(s.patternBuilder.toString());
        this.stdPathPattern = s.stdPathPatternBuilder.toString();
        this.pathParamNames = s.pathParamNames;
        for (String pName : this.pathParamNames) {
            if (this.allParamNames.contains(pName)) continue;
            throw new IllegalArgumentException("PathParameter '" + pName + "' could not found in method arguments at " + resourceClass.getName() + "(" + resourceClass.getSimpleName() + ".java:" + this.allLineNumbers[0] + ")");
        }
        if (logger.isInfoEnabled()) {
            int i;
            StringBuilder sb = new StringBuilder("\n\nBuild route ----------------- ").append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())).append(" ------------------------------");
            sb.append("\nResource     : ").append(resourceClass.getName()).append("(").append(resourceClass.getSimpleName()).append(".java:").append(this.allLineNumbers[0]).append(")");
            sb.append("\nMethod       : ").append(method.getName());
            sb.append("\nPathPattern  : ").append(httpMethod).append(" ").append(pathPattern);
            StringBuilder sbPath = new StringBuilder("\nPathParams   : ");
            StringBuilder sbOther = new StringBuilder("\nOtherParams  : ");
            int pSize = this.allParamNames.size();
            if (pSize > 0) {
                for (int i2 = 0; i2 < pSize; ++i2) {
                    String pName = this.allParamNames.get(i2);
                    if (this.pathParamNames.contains(pName)) {
                        sbPath.append(pName).append("(").append(this.allGenericParamTypes.get(i2)).append(")  ");
                        continue;
                    }
                    sbOther.append(pName).append("(").append(this.allGenericParamTypes.get(i2)).append(")  ");
                }
            }
            sb.append((CharSequence)sbPath).append((CharSequence)sbOther);
            Type returnType = method.getGenericReturnType();
            sb.append("\nReturnType   : ").append(returnType);
            sb.append("\nDescriptions : ").append(des);
            if (validators != null && validators.length > 0 && this.validsLineNumbers != null) {
                sb.append("\nValidators   : ");
                i = 0;
                for (Validator validator : validators) {
                    if (i > 0) {
                        sb.append("\n               ");
                    }
                    Class<?> vc = validator.getClass();
                    sb.append(vc.getName()).append("(").append(vc.getSimpleName()).append(".java:").append(this.validsLineNumbers[i][0]).append(")");
                    ++i;
                }
            }
            if (interceptors != null && interceptors.length > 0 && this.interceptorsLineNumbers != null) {
                sb.append("\nInterceptors : ");
                i = 0;
                for (Interceptor interceptor : interceptors) {
                    if (i > 0) {
                        sb.append("\n               ");
                    }
                    Class<?> ic = interceptor.getClass();
                    sb.append(ic.getName()).append("(").append(ic.getSimpleName()).append(".java:").append(this.interceptorsLineNumbers[i][0]).append(")");
                    ++i;
                }
            }
            sb.append("\n--------------------------------------------------------------------------------\n");
            logger.info(sb.toString());
        }
    }

    public RouteMatch match(HttpRequest request, HttpResponse response) {
        Matcher m;
        if (!this.httpMethod.equals(request.getHttpMethod())) {
            return null;
        }
        String restPath = request.getRestPath();
        String extension = "";
        if (restPath.contains(".")) {
            int index = restPath.lastIndexOf(".");
            extension = restPath.substring(index + 1);
            if (RenderFactory.contains(extension)) {
                restPath = restPath.substring(0, index);
            } else {
                extension = "";
            }
        }
        if (!(m = this.pattern.matcher(restPath)).matches()) {
            return null;
        }
        if (this.headers.size() > 0) {
            for (Map.Entry<String, String> headersEntry : this.headers.entrySet()) {
                if (headersEntry.getValue().equals(request.getHeader(headersEntry.getKey()))) continue;
                return null;
            }
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        for (int i = 0; i < m.groupCount() && i < this.pathParamNames.size(); ++i) {
            pathParams.put(this.pathParamNames.get(i), m.group(i + 1));
        }
        Map<String, List<String>> formParams = null;
        MultipartParam multipartParam = null;
        if (this.multipartBuilder != null) {
            multipartParam = this.multipartBuilder.readMultipart(request);
        }
        RouteMatch routeMatch = null;
        Params params = null;
        Hashtable<String, UploadedFile> fileParams = null;
        String jsonParams = null;
        String contentType = request.getContentType();
        try {
            if (contentType != null && contentType.toLowerCase().contains(ContentType.JSON.value())) {
                String queryString = request.getQueryString();
                if (queryString != null && (this.httpMethod.equals("GET") || this.httpMethod.equals("DELETE")) && Jsoner.isJson(queryString)) {
                    jsonParams = queryString;
                } else {
                    jsonParams = this.getJson(request);
                    formParams = request.getQueryParams();
                }
                this.printMatchRoute(request.getContentType(), jsonParams, pathParams, formParams, null);
                params = this.parseJsonParams(jsonParams, pathParams, formParams);
            } else {
                formParams = request.getQueryParams();
                if (multipartParam != null) {
                    fileParams = multipartParam.getUploadedFiles();
                    if (formParams != null) {
                        formParams.putAll(multipartParam.getParams());
                    } else {
                        formParams = multipartParam.getParams();
                    }
                    this.printMatchRoute(request.getContentType(), null, pathParams, formParams, fileParams);
                    params = this.parseFormParams(pathParams, formParams, fileParams);
                } else {
                    this.printMatchRoute(request.getContentType(), null, pathParams, formParams, null);
                    params = this.parseFormParams(pathParams, formParams, new Hashtable<String, UploadedFile>());
                }
            }
        }
        catch (Exception e) {
            this.printMatchRoute(request.getContentType(), jsonParams, pathParams, formParams, fileParams);
            this.throwException(e);
        }
        routeMatch = new RouteMatch(this.pathPattern, restPath, extension, params, request, response);
        return routeMatch;
    }

    private void printMatchRoute(String contentType, String jsonParams, Map<String, String> pathParams, Map<String, List<String>> formParams, Map<String, UploadedFile> fileParams) {
        if (Constant.showRoute && logger.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder("\n\nMatch route ----------------- ").append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())).append(" ------------------------------");
            sb.append("\nResource     : ").append(this.resourceClass.getName()).append("(").append(this.resourceClass.getSimpleName()).append(".java:" + this.allLineNumbers[0] + ")");
            sb.append("\nMethod       : ").append(this.method.getName());
            sb.append("\nPathPattern  : ").append(this.httpMethod).append(" ").append(this.pathPattern);
            sb.append("\nContentType  : ").append(contentType);
            sb.append("\nPathParams   : ");
            if (pathParams != null && pathParams.size() > 0) {
                Set<Map.Entry<String, String>> paramsEntrySet = pathParams.entrySet();
                for (Map.Entry<String, String> paramsEntry : paramsEntrySet) {
                    sb.append(paramsEntry.getKey()).append(" = {").append(paramsEntry.getValue()).append("}");
                    sb.append("  ");
                }
            }
            if (formParams != null && formParams.size() > 0) {
                sb.append("\nFormParams   : ");
                Set<Map.Entry<String, List<String>>> formParamsEntrySet = formParams.entrySet();
                for (Map.Entry<String, List<String>> entry : formParamsEntrySet) {
                    List<String> values = entry.getValue();
                    if (values.size() >= 1) {
                        sb.append(entry.getKey()).append(" = {").append(values.get(0)).append("}");
                    }
                    sb.append("  ");
                }
            }
            if (jsonParams != null) {
                sb.append("\nJsonParams   : ").append(jsonParams);
            }
            if (fileParams != null && fileParams.size() > 0) {
                sb.append("\nFileParams   : ");
                Set<Map.Entry<String, UploadedFile>> fileParamsEntrySet = fileParams.entrySet();
                for (Map.Entry<String, Object> entry : fileParamsEntrySet) {
                    UploadedFile value = (UploadedFile)entry.getValue();
                    sb.append(entry.getKey()).append(" = {").append(value.getOriginalFileName()).append("(").append(value.getContentType()).append(")}");
                    sb.append("  ");
                }
            }
            Type returnType = this.method.getGenericReturnType();
            sb.append("\nReturnType   : ").append(returnType);
            if (this.validators != null && this.validators.length > 0) {
                sb.append("\nValidators   : ");
                int i = 0;
                for (Iterator<Map.Entry<String, Object>> iterator : this.validators) {
                    if (i > 0) {
                        sb.append("\n               ");
                    }
                    Class<?> vc = iterator.getClass();
                    sb.append(vc.getName()).append("(").append(vc.getSimpleName()).append(".java:").append(this.validsLineNumbers[i][0]).append(")");
                    ++i;
                }
            }
            if (this.interceptors != null && this.interceptors.length > 0) {
                sb.append("\nInterceptors : ");
                int i = 0;
                for (Iterator<Map.Entry<String, Object>> iterator : this.interceptors) {
                    if (i > 0) {
                        sb.append("\n               ");
                    }
                    Class<?> ic = iterator.getClass();
                    sb.append(ic.getName()).append("(").append(ic.getSimpleName()).append(".java:").append(this.interceptorsLineNumbers[i][0]).append(")");
                    ++i;
                }
            }
            sb.append("\n--------------------------------------------------------------------------------\n");
            logger.info(sb.toString());
        }
    }

    public String toString() {
        return this.httpMethod + " " + this.pathPattern + " " + Joiner.on(",").join(this.allParamNames);
    }

    public Class<? extends Resource> getResourceClass() {
        return this.resourceClass;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getPattern() {
        return this.pattern.pattern();
    }

    public String getPathPattern() {
        return this.pathPattern;
    }

    public String getStdPathPattern() {
        return this.stdPathPattern;
    }

    public List<String> getPathParamNames() {
        return this.pathParamNames;
    }

    public List<String> getAllParamNames() {
        return this.allParamNames;
    }

    public List<Class<?>> getAllParamTypes() {
        return this.allParamTypes;
    }

    public List<Type> getAllGenericParamTypes() {
        return this.allGenericParamTypes;
    }

    public Interceptor[] getInterceptors() {
        return this.interceptors;
    }

    public Validator[] getValidators() {
        return this.validators;
    }

    public int[] getAllLineNumbers() {
        return this.allLineNumbers;
    }

    public MultipartBuilder getMultipartBuilder() {
        return this.multipartBuilder;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void throwException(Throwable throwable) {
        if (throwable instanceof WebException) {
            throw (WebException)throwable;
        }
        WebException exception = this.getWebException(throwable, 0);
        Throwable cause = throwable.getCause();
        if (cause != null) {
            logger.error("Route method invoke error.", cause);
        } else {
            logger.error("Route method invoke error.", throwable);
        }
        throw exception;
    }

    private WebException getWebException(Throwable throwable, int deep) {
        WebException result = null;
        String message = throwable.getMessage();
        if (message == null) {
            Throwable cause = throwable.getCause();
            if (cause != null) {
                if (cause instanceof WebException) {
                    result = (WebException)cause;
                } else {
                    message = cause.getMessage();
                    if (message == null && !throwable.equals(cause) && deep < 100) {
                        result = this.getWebException(cause, ++deep);
                    }
                }
            }
        } else if (throwable instanceof WebException) {
            result = (WebException)throwable;
        }
        if (result == null) {
            result = new WebException(HttpStatus.INTERNAL_SERVER_ERROR, message);
        }
        return result;
    }

    private String getJson(HttpRequest request) {
        String json = null;
        try {
            InputStream is = request.getContentStream();
            if (is != null) {
                json = StreamReader.readString(is);
            }
        }
        catch (IOException e) {
            String msg = "Could not read inputStream when contentType is '" + request.getContentType() + "'.";
            logger.error(msg, e);
            throw new WebException(msg);
        }
        return json;
    }

    private Params parseFormParams(Map<String, String> pathParams, Map<String, List<String>> formParams, Map<String, UploadedFile> fileParams) throws IllegalAccessException, InstantiationException {
        String name;
        Params params = new Params();
        int i = 0;
        Class<?> paramType = null;
        List<String> valueArr = null;
        for (String name2 : this.allParamNames) {
            paramType = this.allParamTypes.get(i);
            if (this.pathParamNames.contains(name2)) {
                if (paramType == String.class) {
                    params.set(name2, pathParams.get(name2));
                } else {
                    params.set(name2, ModelDeserializer.parse(pathParams.get(name2), paramType));
                }
            } else if (paramType == UploadedFile.class) {
                params.set(name2, fileParams.remove(name2));
            } else if (paramType == Map.class) {
                Type[] typeArguments = ((ParameterizedType)this.allGenericParamTypes.get(i)).getActualTypeArguments();
                if (typeArguments.length >= 2) {
                    Class keyTypeClass = (Class)typeArguments[0];
                    Class valueTypeClass = (Class)typeArguments[1];
                    if (keyTypeClass == String.class && valueTypeClass == UploadedFile.class) {
                        params.set(name2, fileParams);
                    } else {
                        valueArr = formParams.remove(name2);
                        params.set(name2, this.parseString(paramType, valueArr));
                    }
                } else {
                    valueArr = formParams.remove(name2);
                    params.set(name2, this.parseString(paramType, valueArr));
                }
            } else {
                valueArr = formParams.remove(name2);
                params.set(name2, this.parseString(paramType, valueArr));
            }
            ++i;
        }
        if (formParams.size() > 0) {
            for (Map.Entry<String, Object> entry : formParams.entrySet()) {
                name = entry.getKey();
                if (params.containsName(name)) continue;
                valueArr = (List<String>)entry.getValue();
                if (valueArr != null && valueArr.size() > 0) {
                    params.set(name, valueArr.get(0));
                    continue;
                }
                params.set(name, null);
            }
        }
        if (fileParams.size() > 0) {
            for (Map.Entry<String, Object> entry : fileParams.entrySet()) {
                name = entry.getKey();
                if (params.containsName(name)) continue;
                params.set(entry.getKey(), entry.getValue());
            }
        }
        return params;
    }

    private Object parseString(Class paramType, List<String> valueArr) throws InstantiationException, IllegalAccessException {
        Object result = null;
        if (valueArr != null && valueArr.size() > 0) {
            String value = valueArr.get(0);
            result = paramType == String.class ? value : ModelDeserializer.parse(value, paramType);
        }
        return result;
    }

    private Params parseJsonParams(String json, Map<String, String> pathParams, Map<String, List<String>> formParams) throws IllegalAccessException, InstantiationException {
        String name;
        Params params = new Params();
        int i = 0;
        Class<?> paramType = null;
        boolean oneParamParse = false;
        int paramSize = this.allParamNames.size() - this.pathParamNames.size();
        if (Constant.oneParamParse) {
            oneParamParse = paramSize == 1;
        }
        Object obj = null;
        List<String> valueArr = null;
        boolean hasJsonParam = null != json && !"".equals(json);
        Object receiveParams = null;
        if (hasJsonParam && !oneParamParse) {
            receiveParams = json.startsWith("\"") || json.startsWith("{") || json.startsWith("[") ? Jsoner.toObject(json) : Jsoner.toObject("\"" + json + "\"");
            hasJsonParam = receiveParams != null;
        }
        for (String name2 : this.allParamNames) {
            paramType = this.allParamTypes.get(i);
            if (this.pathParamNames.contains(name2)) {
                if (paramType == String.class) {
                    params.set(name2, pathParams.get(name2));
                } else {
                    params.set(name2, Jsoner.toObject(pathParams.get(name2), paramType));
                }
            } else {
                if (hasJsonParam) {
                    if (oneParamParse) {
                        params.set(name2, this.parse(this.allGenericParamTypes.get(i), paramType, ModelDeserializer.parse(json, paramType)));
                    } else if (receiveParams instanceof Map && (obj = (Object)((Map)receiveParams).remove(name2)) != null) {
                        if (paramType == String.class) {
                            params.set(name2, obj.toString());
                        } else {
                            params.set(name2, this.parse(this.allGenericParamTypes.get(i), paramType, obj));
                        }
                    }
                }
                if (!params.containsName(name2)) {
                    if (formParams != null && formParams.size() > 0) {
                        valueArr = formParams.remove(name2);
                    }
                    params.set(name2, this.parseString(paramType, valueArr));
                }
            }
            ++i;
        }
        if (hasJsonParam && receiveParams instanceof Map && !oneParamParse) {
            for (Map.Entry<String, List<String>> entry : ((Map)receiveParams).entrySet()) {
                name = entry.getKey();
                if (params.containsName(name)) continue;
                params.set(entry.getKey(), entry.getValue());
            }
        }
        if (formParams != null && formParams.size() > 0) {
            for (Map.Entry<String, List<String>> entry : formParams.entrySet()) {
                name = entry.getKey();
                if (params.containsName(name)) continue;
                valueArr = entry.getValue();
                if (valueArr != null && valueArr.size() > 0) {
                    params.set(name, valueArr.get(0));
                    continue;
                }
                params.set(name, null);
            }
        }
        return params;
    }

    private Object parse(Type genericParamType, Class paramType, Object obj) throws InstantiationException, IllegalAccessException {
        Cloneable result = null;
        if (obj != null) {
            if (Map.class.isAssignableFrom(paramType)) {
                Class keyTypeClass = (Class)((ParameterizedType)genericParamType).getActualTypeArguments()[0];
                Class paramTypeClass = (Class)((ParameterizedType)genericParamType).getActualTypeArguments()[1];
                Map map = (Map)obj;
                HashMap<Object, Object> newMap = new HashMap<Object, Object>();
                Set mapEntry = map.entrySet();
                for (Map.Entry entry : mapEntry) {
                    newMap.put(ModelDeserializer.parse(entry.getKey(), keyTypeClass), ModelDeserializer.parse(entry.getValue(), paramTypeClass));
                }
                result = newMap;
            } else if (Collection.class.isAssignableFrom(paramType)) {
                Class paramTypeClass = (Class)((ParameterizedType)genericParamType).getActualTypeArguments()[0];
                if (List.class.isAssignableFrom(paramType)) {
                    if (Entity.class.isAssignableFrom(paramTypeClass)) {
                        List list = (List)obj;
                        ArrayList<Entity> newlist = new ArrayList<Entity>();
                        for (JSONObject jo : list) {
                            newlist.add(ModelDeserializer.deserialze(jo, paramTypeClass));
                        }
                        result = newlist;
                    } else {
                        ArrayList<Object> newblist;
                        List blist = (List)obj;
                        if (String.class == paramTypeClass) {
                            newblist = new ArrayList<Object>();
                            for (Object o : blist) {
                                newblist.add(o.toString());
                            }
                        } else {
                            newblist = new ArrayList();
                            for (Object o : blist) {
                                if (paramTypeClass.isAssignableFrom(o.getClass())) {
                                    newblist.add(o);
                                    continue;
                                }
                                newblist.add(ModelDeserializer.parse(o, paramTypeClass));
                            }
                        }
                        result = newblist;
                    }
                } else if (Set.class.isAssignableFrom(paramType)) {
                    if (Entity.class.isAssignableFrom(paramTypeClass)) {
                        Set set = (Set)obj;
                        HashSet<Entity> newset = new HashSet<Entity>();
                        for (JSONObject jo : set) {
                            newset.add(ModelDeserializer.deserialze(jo, paramTypeClass));
                        }
                        result = newset;
                    } else {
                        HashSet<Object> newbset;
                        Set bset = (Set)obj;
                        if (String.class == paramTypeClass) {
                            newbset = new HashSet<Object>();
                            for (Object o : bset) {
                                newbset.add(o.toString());
                            }
                        } else {
                            newbset = new HashSet();
                            for (Object o : bset) {
                                if (paramTypeClass.isAssignableFrom(o.getClass())) {
                                    newbset.add(o);
                                    continue;
                                }
                                newbset.add(ModelDeserializer.parse(o, paramTypeClass));
                            }
                        }
                        result = newbset;
                    }
                }
            } else {
                result = ModelDeserializer.parse(obj, paramType);
            }
        }
        return result;
    }

    private static final class SimpleColumnBasedPathParamParserCharProcessor
    implements PathParserCharProcessor {
        private StringBuilder pathParamName = new StringBuilder();

        private SimpleColumnBasedPathParamParserCharProcessor() {
        }

        @Override
        public void handle(int curChar, PathPatternParser pathPatternParser) {
            if (curChar == 47) {
                pathPatternParser.patternBuilder.append(Route.PARAM_PATTERN);
                pathPatternParser.stdPathPatternBuilder.append("{").append((CharSequence)this.pathParamName).append("}");
                pathPatternParser.pathParamNames.add(this.pathParamName.toString());
                pathPatternParser.processor = regularCharPathParserCharProcessor;
                pathPatternParser.processor.handle(curChar, pathPatternParser);
            } else {
                this.pathParamName.appendCodePoint(curChar);
            }
        }

        @Override
        public void end(PathPatternParser pathPatternParser) {
            pathPatternParser.patternBuilder.append(Route.PARAM_PATTERN);
            pathPatternParser.stdPathPatternBuilder.append("{").append((CharSequence)this.pathParamName).append("}");
            pathPatternParser.pathParamNames.add(this.pathParamName.toString());
        }
    }

    private static final class CurlyBracesPathParamPathParserCharProcessor
    implements PathParserCharProcessor {
        private int openBr = 1;
        private boolean inRegexDef;
        private StringBuilder pathParamName = new StringBuilder();
        private StringBuilder pathParamRegex = new StringBuilder();

        private CurlyBracesPathParamPathParserCharProcessor() {
        }

        @Override
        public void handle(int curChar, PathPatternParser pathPatternParser) {
            if (curChar == 125) {
                --this.openBr;
                if (this.openBr == 0) {
                    if (this.pathParamName.length() == 0) {
                        pathPatternParser.processor = regularCharPathParserCharProcessor;
                        pathPatternParser.patternBuilder.append("{}");
                        pathPatternParser.stdPathPatternBuilder.append("{}");
                        return;
                    }
                    Checker.checkArgument(this.pathParamRegex.length() != 1, "illegal path parameter definition '%s' at offset %d - custom regex must not be empty", pathPatternParser.pathPattern, pathPatternParser.offset);
                    if (this.pathParamRegex.length() == 0) {
                        this.pathParamRegex.append(Route.PARAM_PATTERN);
                    } else {
                        this.pathParamRegex.append(")");
                    }
                    pathPatternParser.processor = regularCharPathParserCharProcessor;
                    pathPatternParser.patternBuilder.append((CharSequence)this.pathParamRegex);
                    pathPatternParser.stdPathPatternBuilder.append("{").append((CharSequence)this.pathParamName).append("}");
                    pathPatternParser.pathParamNames.add(this.pathParamName.toString());
                    return;
                }
            } else if (curChar == 123) {
                ++this.openBr;
            }
            if (this.inRegexDef) {
                this.pathParamRegex.appendCodePoint(curChar);
            } else if (curChar == 58) {
                this.inRegexDef = true;
                this.pathParamRegex.append("(");
            } else {
                Checker.checkArgument(Character.isLetterOrDigit(curChar), "illegal path parameter definition '%s' at offset %d - only letters and digits are authorized in path param name", pathPatternParser.pathPattern, pathPatternParser.offset);
                this.pathParamName.appendCodePoint(curChar);
            }
        }

        @Override
        public void end(PathPatternParser pathPatternParser) {
        }
    }

    private static final class PathPatternParser {
        final int length;
        final String pathPattern;
        int offset = 0;
        PathParserCharProcessor processor = Route.access$300();
        List<String> pathParamNames = new ArrayList<String>();
        StringBuilder patternBuilder = new StringBuilder();
        StringBuilder stdPathPatternBuilder = new StringBuilder();

        private PathPatternParser(String pathPattern) {
            this.length = pathPattern.length();
            this.pathPattern = pathPattern;
        }

        void parse() {
            while (this.offset < this.length) {
                int curChar = this.pathPattern.codePointAt(this.offset);
                this.processor.handle(curChar, this);
                this.offset += Character.charCount(curChar);
            }
            this.processor.end(this);
        }
    }

    private static interface PathParserCharProcessor {
        public void handle(int var1, PathPatternParser var2);

        public void end(PathPatternParser var1);
    }
}

