/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.route.core;

import com.cybermkd.common.entity.CaseInsensitiveMap;
import com.cybermkd.common.spring.SpringBuilder;
import com.cybermkd.common.spring.SpringHolder;
import com.cybermkd.common.util.analysis.ParamAttribute;
import com.cybermkd.common.util.analysis.ParamNamesScaner;
import com.cybermkd.route.annotation.API;
import com.cybermkd.route.annotation.DELETE;
import com.cybermkd.route.annotation.GET;
import com.cybermkd.route.annotation.PATCH;
import com.cybermkd.route.annotation.POST;
import com.cybermkd.route.annotation.PUT;
import com.cybermkd.route.config.InterceptorLoader;
import com.cybermkd.route.config.ResourceLoader;
import com.cybermkd.route.core.Resource;
import com.cybermkd.route.core.Route;
import com.cybermkd.route.core.multipart.FILE;
import com.cybermkd.route.core.multipart.MultipartBuilder;
import com.cybermkd.route.interceptor.Interceptor;
import com.cybermkd.route.interceptor.InterceptorBuilder;
import com.cybermkd.route.valid.Validator;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class RouteBuilder {
    private ResourceLoader resourceLoader;
    private InterceptorLoader interceptorLoader;
    private Map<String, Map<String, Set<Route>>> routesMap = new CaseInsensitiveMap<Map<String, Set<Route>>>();

    public RouteBuilder(ResourceLoader resourceLoader, InterceptorLoader interceptorLoader) {
        this.resourceLoader = resourceLoader;
        this.interceptorLoader = interceptorLoader;
    }

    private void addRoute(String httpMethod, String apiPath, String methodPath, String des, MultipartBuilder multipartBuilder, Map<String, String> headers, Interceptor[] routeInters, Map<String, ParamAttribute> classParamNames, Class<? extends Validator>[] validClasses, Class<? extends Resource> resourceClazz, Method method) {
        Route route = new Route(resourceClazz, ParamNamesScaner.getParamNames(method, classParamNames), httpMethod, this.getApi(apiPath, methodPath), method, routeInters, des, this.getValidators(validClasses), multipartBuilder, headers);
        if (apiPath.contains("([^\\/]+)")) {
            throw new IllegalArgumentException("Api path could not contains pattern. Because this is a resource url.");
        }
        if (this.routesMap.containsKey(httpMethod)) {
            Map<String, Set<Route>> routesHttpMethodMap = this.routesMap.get(httpMethod);
            if (routesHttpMethodMap.containsKey(apiPath)) {
                Set<Route> routes = routesHttpMethodMap.get(apiPath);
                for (Route r : routes) {
                    if (!r.getHttpMethod().equals(route.getHttpMethod()) || !r.getPattern().equals(route.getPattern()) || !this.matchHeaders(r.getHeaders(), route.getHeaders())) continue;
                    throw new IllegalArgumentException("Same path pattern '" + route.getHttpMethod() + " " + route.getPattern() + "' (" + route.getResourceClass().getSimpleName() + ".java:" + route.getAllLineNumbers()[0] + ")");
                }
                this.routesMap.get(httpMethod).get(apiPath).add(route);
            } else {
                this.routesMap.get(httpMethod).put(apiPath, this.newRouteDESCSet(route));
            }
        } else {
            this.routesMap.put(httpMethod, this.newRouteMap(apiPath, route));
        }
    }

    public boolean matchHeaders(Map<String, String> source, Map<String, String> dist) {
        boolean result = true;
        if (source.size() == dist.size()) {
            for (Map.Entry<String, String> sourceEntry : source.entrySet()) {
                if (sourceEntry.getValue().equals(dist.get(sourceEntry.getKey()))) continue;
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    public void build() {
        InterceptorBuilder interceptorBuilder = new InterceptorBuilder();
        Interceptor[] defaultInters = this.interceptorLoader.getInterceptorArray();
        interceptorBuilder.addToInterceptorsMap(defaultInters);
        FILE file = null;
        DELETE delete = null;
        GET get = null;
        POST post = null;
        PUT put = null;
        PATCH patch = null;
        String apiPath = "";
        MultipartBuilder multipartBuilder = null;
        for (Class<? extends Resource> resourceClazz : this.resourceLoader.getResources()) {
            if (SpringHolder.alive) {
                SpringBuilder.register(resourceClazz);
            }
            Interceptor[] resourceInters = interceptorBuilder.buildResourceInterceptors(resourceClazz);
            Map<String, ParamAttribute> classParamNames = ParamNamesScaner.getParamNames(resourceClazz);
            apiPath = this.getApi(resourceClazz);
            Method[] methods = Modifier.isAbstract(resourceClazz.getSuperclass().getModifiers()) ? resourceClazz.getMethods() : resourceClazz.getDeclaredMethods();
            for (Method method : methods) {
                Interceptor[] routeInters;
                Interceptor[] methodInters;
                file = method.getAnnotation(FILE.class);
                multipartBuilder = file != null ? new MultipartBuilder(file.dir(), file.overwrite(), file.renamer(), file.max(), file.encoding(), file.allows()) : null;
                delete = method.getAnnotation(DELETE.class);
                if (delete != null) {
                    methodInters = interceptorBuilder.buildMethodInterceptors(method);
                    routeInters = interceptorBuilder.buildRouteInterceptors(defaultInters, resourceInters, resourceClazz, methodInters, method);
                    this.addRoute("DELETE", apiPath, delete.value(), delete.des(), multipartBuilder, this.getApiHeader(resourceClazz, delete), routeInters, classParamNames, delete.valid(), resourceClazz, method);
                    continue;
                }
                get = method.getAnnotation(GET.class);
                if (get != null) {
                    methodInters = interceptorBuilder.buildMethodInterceptors(method);
                    routeInters = interceptorBuilder.buildRouteInterceptors(defaultInters, resourceInters, resourceClazz, methodInters, method);
                    this.addRoute("GET", apiPath, get.value(), get.des(), multipartBuilder, this.getApiHeader(resourceClazz, get), routeInters, classParamNames, get.valid(), resourceClazz, method);
                    continue;
                }
                post = method.getAnnotation(POST.class);
                if (post != null) {
                    methodInters = interceptorBuilder.buildMethodInterceptors(method);
                    routeInters = interceptorBuilder.buildRouteInterceptors(defaultInters, resourceInters, resourceClazz, methodInters, method);
                    this.addRoute("POST", apiPath, post.value(), post.des(), multipartBuilder, this.getApiHeader(resourceClazz, post), routeInters, classParamNames, post.valid(), resourceClazz, method);
                    continue;
                }
                put = method.getAnnotation(PUT.class);
                if (put != null) {
                    methodInters = interceptorBuilder.buildMethodInterceptors(method);
                    routeInters = interceptorBuilder.buildRouteInterceptors(defaultInters, resourceInters, resourceClazz, methodInters, method);
                    this.addRoute("PUT", apiPath, put.value(), put.des(), multipartBuilder, this.getApiHeader(resourceClazz, put), routeInters, classParamNames, put.valid(), resourceClazz, method);
                    continue;
                }
                patch = method.getAnnotation(PATCH.class);
                if (patch == null) continue;
                methodInters = interceptorBuilder.buildMethodInterceptors(method);
                routeInters = interceptorBuilder.buildRouteInterceptors(defaultInters, resourceInters, resourceClazz, methodInters, method);
                this.addRoute("PATCH", apiPath, patch.value(), patch.des(), multipartBuilder, this.getApiHeader(resourceClazz, patch), routeInters, classParamNames, patch.valid(), resourceClazz, method);
            }
        }
    }

    private Validator[] getValidators(Class<? extends Validator>[] validClasses) {
        Validator[] validators = new Validator[validClasses.length];
        if (validClasses.length > 0) {
            int i = 0;
            for (Class<? extends Validator> valid : validClasses) {
                try {
                    validators[i] = valid.newInstance();
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                ++i;
            }
        }
        return validators;
    }

    private String getApi(Class<? extends Resource> resourceClazz) {
        Class<? extends Resource> superClazz;
        String apiPath = "";
        API api = resourceClazz.getAnnotation(API.class);
        if (api != null && !(apiPath = api.value()).equals("") && !apiPath.startsWith("/")) {
            apiPath = "/" + apiPath;
        }
        if (Resource.class.isAssignableFrom(superClazz = resourceClazz.getSuperclass())) {
            apiPath = this.getApi(superClazz) + apiPath;
        }
        return apiPath;
    }

    private String getApi(String apiPath, String methodPath) {
        if (!methodPath.equals("")) {
            apiPath = !methodPath.startsWith("/") ? apiPath + "/" + methodPath : apiPath + methodPath;
        }
        return apiPath;
    }

    private Map<String, String> getApiHeader(Class<? extends Resource> resourceClazz) {
        Class<? extends Resource> superClazz;
        HashMap<String, String> apiHeaders = new HashMap<String, String>();
        API api = resourceClazz.getAnnotation(API.class);
        if (api != null) {
            String[] apiHeaderValue = api.headers();
            apiHeaders.putAll(this.getApiHeaderValue(apiHeaderValue));
        }
        if (Resource.class.isAssignableFrom(superClazz = resourceClazz.getSuperclass())) {
            apiHeaders.putAll(this.getApiHeader(superClazz));
        }
        return apiHeaders;
    }

    private Map<String, String> getApiHeaderValue(String[] apiHeaderValue) {
        HashMap<String, String> apiHeaders = new HashMap<String, String>();
        if (apiHeaderValue.length > 0) {
            for (String apiHeader : apiHeaderValue) {
                String[] apiHeaderArr = apiHeader.split(":");
                apiHeaders.put(apiHeaderArr[0].trim(), apiHeaderArr[1].trim());
            }
        }
        return apiHeaders;
    }

    private Map<String, String> getApiHeader(Class<? extends Resource> resourceClazz, POST post) {
        Map<String, String> apiHeaders = this.getApiHeader(resourceClazz);
        String[] apiHeaderValue = post.headers();
        apiHeaders.putAll(this.getApiHeaderValue(apiHeaderValue));
        return apiHeaders;
    }

    private Map<String, String> getApiHeader(Class<? extends Resource> resourceClazz, DELETE delete) {
        Map<String, String> apiHeaders = this.getApiHeader(resourceClazz);
        String[] apiHeaderValue = delete.headers();
        apiHeaders.putAll(this.getApiHeaderValue(apiHeaderValue));
        return apiHeaders;
    }

    private Map<String, String> getApiHeader(Class<? extends Resource> resourceClazz, PUT put) {
        Map<String, String> apiHeaders = this.getApiHeader(resourceClazz);
        String[] apiHeaderValue = put.headers();
        apiHeaders.putAll(this.getApiHeaderValue(apiHeaderValue));
        return apiHeaders;
    }

    private Map<String, String> getApiHeader(Class<? extends Resource> resourceClazz, GET get) {
        Map<String, String> apiHeaders = this.getApiHeader(resourceClazz);
        String[] apiHeaderValue = get.headers();
        apiHeaders.putAll(this.getApiHeaderValue(apiHeaderValue));
        return apiHeaders;
    }

    private Map<String, String> getApiHeader(Class<? extends Resource> resourceClazz, PATCH patch) {
        Map<String, String> apiHeaders = this.getApiHeader(resourceClazz);
        String[] apiHeaderValue = patch.headers();
        apiHeaders.putAll(this.getApiHeaderValue(apiHeaderValue));
        return apiHeaders;
    }

    public Map<String, Map<String, Set<Route>>> getRoutesMap() {
        return Collections.unmodifiableMap(this.routesMap);
    }

    public Map<String, Set<Route>> newRouteMap(final String apiPath, final Route route) {
        return new TreeMap<String, Set<Route>>((Comparator)new Comparator<String>(){

            @Override
            public int compare(String k1, String k2) {
                int result = k2.length() - k1.length();
                if (result == 0) {
                    return k1.compareTo(k2);
                }
                return result;
            }
        }){
            {
                super(x0);
                this.put(apiPath, RouteBuilder.this.newRouteDESCSet(route));
            }
        };
    }

    public Set<Route> newRouteDESCSet(final Route route) {
        return new TreeSet<Route>((Comparator)new Comparator<Route>(){

            @Override
            public int compare(Route a, Route b) {
                String one = a.getPattern().replace("/([^\\/]+)", "");
                String two = b.getPattern().replace("/([^\\/]+)", "");
                int result = two.length() - one.length();
                if (result == 0 && (result = a.getHttpMethod().compareTo(b.getHttpMethod())) == 0) {
                    return a.getPathPattern().compareTo(b.getPathPattern());
                }
                return result;
            }
        }){
            {
                super(x0);
                this.add(route);
            }
        };
    }
}

