/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.route.core;

import com.cybermkd.common.http.HttpMethod;
import com.cybermkd.common.http.HttpRequest;
import com.cybermkd.common.http.HttpResponse;
import com.cybermkd.common.http.exception.WebException;
import com.cybermkd.common.http.result.HttpStatus;
import com.cybermkd.log.Logger;
import com.cybermkd.route.core.Route;
import com.cybermkd.route.core.RouteBuilder;
import com.cybermkd.route.core.RouteInvocation;
import com.cybermkd.route.core.RouteMatch;
import com.cybermkd.route.handler.Handler;
import java.util.Map;
import java.util.Set;

public final class RouteHandler
extends Handler {
    private static final Logger logger = Logger.getLogger(RouteHandler.class);
    private final RouteBuilder routeBuilder;

    public RouteHandler(RouteBuilder routeBuilder) {
        this.routeBuilder = routeBuilder;
    }

    @Override
    public final void handle(HttpRequest request, HttpResponse response, boolean[] isHandled) {
        RouteMatch routeMatch = null;
        Route route = null;
        RouteInvocation routeInvocation = null;
        String restPath = request.getRestPath();
        Map<String, Map<String, Set<Route>>> routesMap = this.routeBuilder.getRoutesMap();
        String httpMethod = request.getHttpMethod();
        boolean supportMethod = HttpMethod.support(httpMethod);
        if (supportMethod) {
            if (routesMap.containsKey(httpMethod)) {
                Set<Map.Entry<String, Set<Route>>> routesEntrySet = routesMap.get(httpMethod).entrySet();
                for (Map.Entry<String, Set<Route>> routesEntry : routesEntrySet) {
                    if (!restPath.startsWith(routesEntry.getKey())) continue;
                    Set<Route> routesSet = routesEntry.getValue();
                    for (Route r : routesSet) {
                        routeMatch = r.match(request, response);
                        if (routeMatch == null) continue;
                        route = r;
                        break;
                    }
                    if (routeMatch == null) continue;
                    break;
                }
            }
            if (routeMatch != null) {
                routeInvocation = new RouteInvocation(route, routeMatch);
            }
        }
        isHandled[0] = true;
        if (routeInvocation != null) {
            routeInvocation.invoke();
        } else {
            if (!restPath.equals("/") && supportMethod) {
                throw new WebException(HttpStatus.SERVICE_UNAVAILABLE, "API is unavailable,check request body.");
            }
            isHandled[0] = false;
        }
    }
}

