/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.route.core;

import com.cybermkd.common.http.HttpRequest;
import com.cybermkd.common.http.HttpResponse;
import com.cybermkd.common.http.exception.WebException;
import com.cybermkd.common.http.result.HttpStatus;
import com.cybermkd.common.http.result.WebResult;
import com.cybermkd.common.spring.SpringBuilder;
import com.cybermkd.common.spring.SpringHolder;
import com.cybermkd.common.util.Checker;
import com.cybermkd.log.Logger;
import com.cybermkd.route.core.Headers;
import com.cybermkd.route.core.Params;
import com.cybermkd.route.core.Resource;
import com.cybermkd.route.core.Route;
import com.cybermkd.route.core.RouteMatch;
import com.cybermkd.route.interceptor.Interceptor;
import com.cybermkd.route.render.RenderFactory;
import com.cybermkd.route.valid.ValidResult;
import com.cybermkd.route.valid.Validator;
import java.awt.image.RenderedImage;
import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RouteInvocation {
    private static final Logger logger = Logger.getLogger(RouteInvocation.class);
    private Route route;
    private RouteMatch routeMatch;
    private Interceptor[] interceptors;
    private int index = 0;
    private boolean wasInvoke = false;
    private Object invokeResult = null;

    private RouteInvocation() {
    }

    public RouteInvocation(Route route, RouteMatch routeMatch) {
        this.route = route;
        this.routeMatch = routeMatch;
        this.interceptors = route.getInterceptors();
    }

    private void methodInvoke() {
        if (this.index < this.interceptors.length) {
            this.interceptors[this.index++].intercept(this);
        } else if (this.index++ == this.interceptors.length) {
            try {
                Resource resource = SpringHolder.alive ? SpringBuilder.getBean(this.route.getResourceClass()) : this.route.getResourceClass().newInstance();
                Checker.checkNotNull(resource, "Could init '" + this.route.getResourceClass() + "' before invoke method.");
                resource.setRouteMatch(this.routeMatch);
                Params params = this.routeMatch.getParams();
                this.validate(params);
                Method method = this.route.getMethod();
                method.setAccessible(true);
                if (this.route.getAllParamNames().size() > 0) {
                    List<Class<?>> allParamTypes = this.route.getAllParamTypes();
                    List<String> allParamNames = this.route.getAllParamNames();
                    Object[] args = new Object[allParamNames.size()];
                    int i = 0;
                    for (String name : allParamNames) {
                        if (HttpRequest.class.isAssignableFrom(allParamTypes.get(i))) {
                            args[i++] = this.routeMatch.getRequest();
                            continue;
                        }
                        if (HttpResponse.class.isAssignableFrom(allParamTypes.get(i))) {
                            args[i++] = this.routeMatch.getResponse();
                            continue;
                        }
                        if (Headers.class.isAssignableFrom(allParamTypes.get(i))) {
                            args[i++] = this.routeMatch.getHeaders();
                            continue;
                        }
                        if (Params.class.isAssignableFrom(allParamTypes.get(i))) {
                            args[i++] = this.routeMatch.getParams();
                            continue;
                        }
                        args[i++] = params.get(name);
                    }
                    this.invokeResult = method.invoke((Object)resource, args);
                } else {
                    this.invokeResult = method.invoke((Object)resource, new Object[0]);
                }
                this.wasInvoke = true;
                this.render(this.invokeResult);
            }
            catch (Exception e) {
                this.route.throwException(e);
            }
        }
    }

    public void render(Object invokeResult) {
        Object result;
        HttpRequest request = this.routeMatch.getRequest();
        HttpResponse response = this.routeMatch.getResponse();
        if (invokeResult instanceof WebResult) {
            WebResult webResult = (WebResult)invokeResult;
            response.setStatus(webResult.getStatus());
            Map<String, String> headers = webResult.getHeaders();
            if (headers != null && headers.size() > 0) {
                for (Map.Entry<String, String> headersEntry : headers.entrySet()) {
                    response.setHeader(headersEntry.getKey(), headersEntry.getValue());
                }
            }
            result = webResult.getResult();
        } else {
            result = invokeResult;
        }
        String extension = this.routeMatch.getExtension();
        if (result instanceof File && extension.equals("") || extension.equals("file")) {
            RenderFactory.getFileRender().render(request, response, result);
        } else if (result instanceof RenderedImage && extension.equals("") || extension.equals("image")) {
            if (result instanceof String) {
                RenderFactory.getFileRender().render(request, response, result);
            } else {
                RenderFactory.getImageRender().render(request, response, result);
            }
        } else {
            RenderFactory.get(extension).render(request, response, result);
        }
    }

    private void validate(Params params) {
        Validator[] validators = this.route.getValidators();
        if (validators.length > 0) {
            HashMap<String, Object> errors = new HashMap<String, Object>();
            HttpStatus status = HttpStatus.UNPROCESSABLE_ENTITY;
            for (Validator validator : validators) {
                ValidResult vr = validator.validate(params, this.routeMatch);
                errors.putAll(vr.getErrors());
                if (!status.equals((Object)vr.getStatus())) {
                    status = vr.getStatus();
                }
                if (errors.size() <= 0) continue;
                throw new WebException(status, errors);
            }
        }
    }

    public Method getMethod() {
        return this.route.getMethod();
    }

    public Class getResourceClass() {
        return this.route.getResourceClass();
    }

    public RouteMatch getRouteMatch() {
        return this.routeMatch;
    }

    public Object invoke() {
        if (!this.wasInvoke) {
            this.methodInvoke();
        }
        return this.invokeResult;
    }
}

