/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.route.core;

import com.cybermkd.common.http.HttpRequest;
import com.cybermkd.common.http.HttpResponse;
import com.cybermkd.common.util.Checker;
import com.cybermkd.route.core.Headers;
import com.cybermkd.route.core.Params;

public class RouteMatch {
    private final String pattern;
    private final String path;
    private final String extension;
    private final Params params;
    private final Headers headers;
    private final HttpRequest request;
    private final HttpResponse response;

    public RouteMatch(String pattern, String path, String extension, Params params, HttpRequest request, HttpResponse response) {
        this.pattern = Checker.checkNotNull(pattern);
        this.path = Checker.checkNotNull(path);
        this.params = Checker.checkNotNull(params);
        this.extension = Checker.checkNotNull(extension);
        this.request = Checker.checkNotNull(request);
        this.headers = new Headers(request.getHeaders());
        this.response = Checker.checkNotNull(response);
    }

    public String getPath() {
        return this.path;
    }

    public Params getParams() {
        return this.params;
    }

    public String getExtension() {
        return this.extension;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public String toString() {
        return "RouteMatch{pattern='" + this.pattern + '\'' + ", path='" + this.path + '\'' + '}';
    }
}

