/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.route.core.multipart;

import com.cybermkd.common.Constant;
import com.cybermkd.common.http.HttpRequest;
import com.cybermkd.common.http.exception.WebException;
import com.cybermkd.common.util.stream.FileRenamer;
import com.cybermkd.log.Logger;
import com.cybermkd.route.core.multipart.MultipartParam;
import com.cybermkd.upload.MultipartRequest;
import java.io.File;
import java.io.IOException;

public class MultipartBuilder {
    private static final Logger logger = Logger.getLogger(MultipartBuilder.class);
    private String saveDirectory = Constant.uploadDirectory;
    private int maxPostSize = Constant.uploadMaxSize;
    private String[] uploadAllows;
    private String encoding = Constant.encoding;
    private boolean overwrite = false;
    private FileRenamer renamer = FileRenamer.RENAMER;

    public MultipartBuilder() {
    }

    public MultipartBuilder(String saveDirectory, boolean overwrite, Class<? extends FileRenamer> renamerClass, int maxPostSize, String encoding, String[] uploadAllows) {
        if (saveDirectory != null && !"".equals(saveDirectory)) {
            this.saveDirectory = saveDirectory;
        }
        this.overwrite = overwrite;
        if (this.renamer == null || renamerClass != this.renamer.getClass()) {
            try {
                this.renamer = renamerClass.newInstance();
            }
            catch (InstantiationException e) {
                logger.error("Could not init FileRenamer Class.", e);
            }
            catch (IllegalAccessException e) {
                logger.error("Could not access FileRenamer Class.", e);
            }
        }
        if (maxPostSize > 0) {
            this.maxPostSize = maxPostSize;
        }
        if (encoding != null && !"".equals(encoding)) {
            this.encoding = encoding;
        }
        this.uploadAllows = uploadAllows;
    }

    public MultipartParam readMultipart(HttpRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("Could not found httpRequest for multipartRequest.");
        }
        File saveDir = new File(this.saveDirectory);
        if (!saveDir.exists()) {
            if (!this.saveDirectory.startsWith("/")) {
                this.saveDirectory = "/" + this.saveDirectory;
            }
            saveDir = new File(request.getRealPath("/") + this.saveDirectory);
        }
        if (!saveDir.exists() && !saveDir.mkdirs()) {
            throw new WebException("Directory " + this.saveDirectory + " not exists and can not create directory.");
        }
        MultipartParam multipartParam = null;
        FileRenamer fileRenamer = null;
        if (!this.overwrite && this.renamer != null) {
            fileRenamer = this.renamer;
        }
        try {
            MultipartRequest multipartRequest = new MultipartRequest(request, saveDir, this.maxPostSize, this.encoding, fileRenamer, this.uploadAllows, Constant.uploadDenieds);
            multipartParam = new MultipartParam(multipartRequest.getFiles(), multipartRequest.getParams());
        }
        catch (IOException e) {
            throw new WebException(e.getMessage());
        }
        return multipartParam;
    }
}

