/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.route.handler.cors;

import com.cybermkd.common.http.HttpRequest;
import com.cybermkd.common.http.HttpResponse;
import com.cybermkd.common.http.exception.WebException;
import com.cybermkd.common.http.result.HttpStatus;
import com.cybermkd.common.util.Joiner;
import com.cybermkd.common.util.Lister;
import com.cybermkd.log.Logger;
import com.cybermkd.route.handler.Handler;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CORSHandler
extends Handler {
    public static final String ACCESS_CONTROL_REQUEST_METHOD_HEADER = "Access-Control-Request-Method";
    public static final String ACCESS_CONTROL_REQUEST_HEADERS_HEADER = "Access-Control-Request-Headers";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN_HEADER = "Access-Control-Allow-Origin";
    public static final String ACCESS_CONTROL_ALLOW_METHODS_HEADER = "Access-Control-Allow-Methods";
    public static final String ACCESS_CONTROL_ALLOW_HEADERS_HEADER = "Access-Control-Allow-Headers";
    public static final String ACCESS_CONTROL_MAX_AGE_HEADER = "Access-Control-Max-Age";
    public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER = "Access-Control-Allow-Credentials";
    public static final String ACCESS_CONTROL_EXPOSE_HEADERS_HEADER = "Access-Control-Expose-Headers";
    private static final Logger logger = Logger.getLogger(CORSHandler.class);
    private static final String ORIGIN_HEADER = "Origin";
    private static final List<String> SIMPLE_HTTP_METHODS = Lister.of("GET", "POST", "HEAD");
    private boolean anyOriginAllowed = true;
    private boolean anyHeadersAllowed = false;
    private List<String> allowedOrigins = Lister.of("*");
    private List<String> allowedMethods = Lister.of("GET", "POST", "HEAD");
    private List<String> allowedHeaders = Lister.of("X-Requested-With", "Content-Type", "Accept", "Origin");
    private List<String> exposedHeaders = null;
    private int preflightMaxAge = 1800;
    private boolean allowCredentials = true;
    private boolean chainPreflight = true;

    public CORSHandler() {
    }

    public CORSHandler(String allowedMethods) {
        this(null, allowedMethods, null);
    }

    public CORSHandler(String allowedMethods, String allowedHeaders) {
        this(null, allowedMethods, allowedHeaders);
    }

    public CORSHandler(String allowedOrigins, String allowedMethods, String allowedHeaders) {
        this(allowedOrigins, allowedMethods, allowedHeaders, null);
    }

    public CORSHandler(String allowedOrigins, String allowedMethods, String allowedHeaders, String exposedHeaders) {
        if (allowedOrigins != null) {
            this.allowedOrigins = Lister.of(allowedOrigins.split(","));
        }
        if (allowedMethods != null) {
            this.allowedMethods = Lister.of(allowedMethods.split(","));
        }
        if (allowedHeaders != null) {
            this.allowedHeaders = Lister.of(allowedHeaders.split(","));
        }
        if (exposedHeaders != null) {
            this.exposedHeaders = Lister.of(exposedHeaders.split(","));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void handle(HttpRequest request, HttpResponse response, boolean[] isHandled) {
        String origin = request.getHeader(ORIGIN_HEADER);
        if (origin != null && this.isEnabled(request)) {
            if (this.originMatches(origin)) {
                if (this.isSimpleRequest(request)) {
                    logger.debug("Cross-origin request to %s is a simple cross-origin request", request.getRestPath());
                    this.handleSimpleResponse(request, response, origin);
                } else if (this.isPreflightRequest(request)) {
                    logger.debug("Cross-origin request to %s is a preflight cross-origin request", request.getRestPath());
                    this.handlePreflightResponse(request, response, origin);
                    if (!this.chainPreflight) throw new WebException(HttpStatus.FORBIDDEN, "Unauthorized CORS request");
                    logger.debug("Preflight cross-origin request to %s forwarded to application", request.getRestPath());
                } else {
                    logger.debug("Cross-origin request to %s is a non-simple cross-origin request", request.getRestPath());
                    this.handleSimpleResponse(request, response, origin);
                }
            } else {
                logger.debug("Cross-origin request to " + request.getRestPath() + " with origin " + origin + " does not match allowed origins " + this.allowedOrigins);
            }
        }
        this.nextHandler.handle(request, response, isHandled);
    }

    protected boolean isEnabled(HttpRequest request) {
        Enumeration<String> connections = request.getHeaders("Connection");
        while (connections.hasMoreElements()) {
            String connection = connections.nextElement();
            if (!"Upgrade".equalsIgnoreCase(connection)) continue;
            Enumeration<String> upgrades = request.getHeaders("Upgrade");
            while (upgrades.hasMoreElements()) {
                String upgrade = upgrades.nextElement();
                if (!"WebSocket".equalsIgnoreCase(upgrade)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean originMatches(String originList) {
        String[] origins;
        if (this.anyOriginAllowed) {
            return true;
        }
        if (originList.trim().length() == 0) {
            return false;
        }
        for (String origin : origins = originList.split(" ")) {
            if (origin.trim().length() == 0) continue;
            for (String allowedOrigin : this.allowedOrigins) {
                Matcher matcher;
                if (!(allowedOrigin.contains("*") ? (matcher = this.createMatcher(origin, allowedOrigin)).matches() : allowedOrigin.equals(origin))) continue;
                return true;
            }
        }
        return false;
    }

    private Matcher createMatcher(String origin, String allowedOrigin) {
        String regex = this.parseAllowedWildcardOriginToRegex(allowedOrigin);
        Pattern pattern = Pattern.compile(regex);
        return pattern.matcher(origin);
    }

    private String parseAllowedWildcardOriginToRegex(String allowedOrigin) {
        String regex = allowedOrigin.replace(".", "\\.");
        return regex.replace("*", ".*");
    }

    private boolean isSimpleRequest(HttpRequest request) {
        if (SIMPLE_HTTP_METHODS.contains(request.getHttpMethod())) {
            return request.getHeader(ACCESS_CONTROL_REQUEST_METHOD_HEADER) == null;
        }
        return false;
    }

    private boolean isPreflightRequest(HttpRequest request) {
        if ("OPTIONS".equalsIgnoreCase(request.getHttpMethod())) {
            return true;
        }
        return request.getHeader(ACCESS_CONTROL_REQUEST_METHOD_HEADER) != null;
    }

    private void handleSimpleResponse(HttpRequest request, HttpResponse response, String origin) {
        response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN_HEADER, origin);
        if (!this.anyOriginAllowed) {
            response.addHeader("Vary", ORIGIN_HEADER);
        }
        if (this.allowCredentials) {
            response.setHeader(ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER, "true");
        }
        if (this.exposedHeaders != null && !this.exposedHeaders.isEmpty()) {
            response.setHeader(ACCESS_CONTROL_EXPOSE_HEADERS_HEADER, Joiner.on(",").join(this.exposedHeaders));
        }
    }

    private void handlePreflightResponse(HttpRequest request, HttpResponse response, String origin) {
        boolean methodAllowed = this.isMethodAllowed(request);
        if (!methodAllowed) {
            return;
        }
        List<String> headersRequested = this.getAccessControlRequestHeaders(request);
        boolean headersAllowed = this.areHeadersAllowed(headersRequested);
        if (!headersAllowed) {
            return;
        }
        response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN_HEADER, origin);
        if (!this.anyOriginAllowed) {
            response.addHeader("Vary", ORIGIN_HEADER);
        }
        if (this.allowCredentials) {
            response.setHeader(ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER, "true");
        }
        if (this.preflightMaxAge > 0) {
            response.setHeader(ACCESS_CONTROL_MAX_AGE_HEADER, String.valueOf(this.preflightMaxAge));
        }
        response.setHeader(ACCESS_CONTROL_ALLOW_METHODS_HEADER, Joiner.on(",").join(this.allowedMethods));
        if (this.anyHeadersAllowed) {
            response.setHeader(ACCESS_CONTROL_ALLOW_HEADERS_HEADER, Joiner.on(",").join(headersRequested));
        } else {
            response.setHeader(ACCESS_CONTROL_ALLOW_HEADERS_HEADER, Joiner.on(",").join(this.allowedHeaders));
        }
    }

    private boolean isMethodAllowed(HttpRequest request) {
        String accessControlRequestMethod = request.getHeader(ACCESS_CONTROL_REQUEST_METHOD_HEADER);
        logger.debug("%s is %s", ACCESS_CONTROL_REQUEST_METHOD_HEADER, accessControlRequestMethod);
        boolean result = false;
        if (accessControlRequestMethod != null) {
            result = this.allowedMethods.contains(accessControlRequestMethod);
        }
        logger.debug("Method %s is" + (result ? "" : " not") + " among allowed methods %s", accessControlRequestMethod, this.allowedMethods);
        return result;
    }

    List<String> getAccessControlRequestHeaders(HttpRequest request) {
        String[] headers;
        String accessControlRequestHeaders = request.getHeader(ACCESS_CONTROL_REQUEST_HEADERS_HEADER);
        logger.debug("%s is %s", ACCESS_CONTROL_REQUEST_HEADERS_HEADER, accessControlRequestHeaders);
        if (accessControlRequestHeaders == null) {
            return Lister.of(new Object[0]);
        }
        List<String> requestedHeaders = Lister.of(new Object[0]);
        for (String header : headers = accessControlRequestHeaders.split(",")) {
            String h = header.trim();
            if (h.length() <= 0) continue;
            requestedHeaders.add(h);
        }
        return requestedHeaders;
    }

    private boolean areHeadersAllowed(List<String> requestedHeaders) {
        if (this.anyHeadersAllowed) {
            logger.debug("Any header is allowed");
            return true;
        }
        boolean result = true;
        for (String requestedHeader : requestedHeaders) {
            boolean headerAllowed = false;
            for (String allowedHeader : this.allowedHeaders) {
                if (!requestedHeader.equalsIgnoreCase(allowedHeader.trim())) continue;
                headerAllowed = true;
                break;
            }
            if (headerAllowed) continue;
            result = false;
            break;
        }
        logger.debug("Headers [%s] are" + (result ? "" : " not") + " among allowed headers %s", requestedHeaders, this.allowedHeaders);
        return result;
    }

    public List<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public void setAllowedOrigins(String ... allowedOrigins) {
        if (allowedOrigins.length == 1 && allowedOrigins[0].equals("*")) {
            this.anyOriginAllowed = true;
        }
        this.allowedOrigins = Lister.of(allowedOrigins);
    }

    public List<String> getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(String ... allowedMethods) {
        this.allowedMethods = Lister.of(allowedMethods);
    }

    public List<String> getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public void setAllowedHeaders(String ... allowedHeaders) {
        if (allowedHeaders.length == 1 && allowedHeaders[0].equals("*")) {
            this.anyHeadersAllowed = true;
        }
        this.allowedHeaders = Lister.of(allowedHeaders);
    }

    public List<String> getExposedHeaders() {
        return this.exposedHeaders;
    }

    public void setExposedHeaders(String ... exposedHeaders) {
        this.exposedHeaders = Lister.of(exposedHeaders);
    }

    public int getPreflightMaxAge() {
        return this.preflightMaxAge;
    }

    public void setPreflightMaxAge(int preflightMaxAge) {
        this.preflightMaxAge = preflightMaxAge;
    }

    public boolean isAllowCredentials() {
        return this.allowCredentials;
    }

    public void setAllowCredentials(boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
    }

    public boolean isChainPreflight() {
        return this.chainPreflight;
    }

    public void setChainPreflight(boolean chainPreflight) {
        this.chainPreflight = chainPreflight;
    }
}

