/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.route.holder;

import com.cybermkd.common.Constant;
import com.cybermkd.common.Render;
import com.cybermkd.common.http.HttpRequest;
import com.cybermkd.common.http.HttpResponse;
import com.cybermkd.common.http.exception.WebException;
import com.cybermkd.common.http.result.HttpStatus;
import com.cybermkd.common.util.json.Jsoner;
import com.cybermkd.log.Logger;
import com.cybermkd.route.holder.ExceptionHolder;
import com.cybermkd.route.render.RenderFactory;

public class DefaultExceptionHolder
extends ExceptionHolder {
    private static final Logger logger = Logger.getLogger(DefaultExceptionHolder.class);

    @Override
    public void hold(HttpRequest request, HttpResponse response, Exception exception, boolean[] isHandled) {
        String restPath = request.getRestPath();
        Render render = RenderFactory.getByUrl(restPath);
        if (exception instanceof WebException) {
            WebException webException = (WebException)exception;
            if (Constant.apiPrefix == null || restPath.startsWith(Constant.apiPrefix)) {
                String message = Jsoner.toJSON(webException.getContent());
                if (logger.isWarnEnabled()) {
                    logger.warn("Request \"" + request.getHttpMethod() + " " + request.getRestPath() + "\" error : " + webException.getStatus().getCode() + " " + message);
                }
                response.setStatus(webException.getStatus());
                render.render(request, response, message);
            } else {
                DefaultExceptionHolder.go(response, webException.getStatus(), isHandled);
            }
        } else {
            Throwable throwable;
            String message = exception.getMessage();
            if (message == null && (throwable = exception.getCause()) != null) {
                message = throwable.getMessage();
            }
            if (logger.isErrorEnabled()) {
                logger.warn("Request \"" + request.getHttpMethod() + " " + request.getRestPath() + "\" error : " + HttpStatus.BAD_REQUEST.getCode() + " " + message, exception);
            }
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
            render.render(request, response, message);
        }
    }
}

