/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.route.holder;

import com.cybermkd.common.Constant;
import com.cybermkd.common.http.HttpRequest;
import com.cybermkd.common.http.HttpResponse;
import com.cybermkd.common.http.result.HttpStatus;
import com.cybermkd.common.util.Checker;
import com.cybermkd.log.Logger;
import com.cybermkd.route.holder.DefaultExceptionHolder;
import java.util.HashMap;
import java.util.Map;

public abstract class ExceptionHolder {
    public static final ExceptionHolder HOLDER;
    private static final Logger logger;
    private static String defaultUrl;
    private static boolean forward;
    private static Map<HttpStatus, String> forwardMap;
    private static Map<HttpStatus, String> redirectMap;

    public static void setDefaultForward(String url) {
        ExceptionHolder.setDefault(url, true);
    }

    public static void setDefaultRedirect(String url) {
        ExceptionHolder.setDefault(url, false);
    }

    private static void setDefault(String url, boolean isForward) {
        if (defaultUrl != null) {
            throw new IllegalArgumentException("Default url only can set once.");
        }
        defaultUrl = Checker.checkNotNull(url, "Url could not be null.");
        forward = isForward;
    }

    public static void addFoward(HttpStatus status, String url) {
        forwardMap.put(status, Checker.checkNotNull(url, "Url could not be null."));
    }

    public static void addRedirect(HttpStatus status, String url) {
        redirectMap.put(status, Checker.checkNotNull(url, "Url could not be null."));
    }

    protected static void go(HttpResponse response, HttpStatus status, boolean[] isHandled) {
        block11: {
            String url = forwardMap.get((Object)status);
            try {
                if (url != null) {
                    response.forward(url);
                } else {
                    url = redirectMap.get((Object)status);
                    if (url != null) {
                        response.sendRedirect(url);
                    } else if (defaultUrl != null) {
                        url = defaultUrl;
                        if (forward) {
                            response.forward(defaultUrl);
                        } else {
                            response.sendRedirect(defaultUrl);
                        }
                    } else {
                        isHandled[0] = false;
                        if (logger.isWarnEnabled()) {
                            logger.warn("ICEREST not handle this request.");
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) break block11;
                logger.error("Response going error.", e);
            }
        }
    }

    public abstract void hold(HttpRequest var1, HttpResponse var2, Exception var3, boolean[] var4);

    static {
        logger = Logger.getLogger(ExceptionHolder.class);
        forwardMap = new HashMap<HttpStatus, String>();
        redirectMap = new HashMap<HttpStatus, String>();
        ExceptionHolder exceptionHolder = null;
        if (Constant.exceptionHolder == null) {
            exceptionHolder = new DefaultExceptionHolder();
        } else {
            try {
                Class<?> holderClass = Class.forName(Constant.exceptionHolder);
                exceptionHolder = (ExceptionHolder)holderClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                logger.error("Could not found ExceptionHolder Class.", e);
            }
            catch (InstantiationException e) {
                logger.error("Could not init ExceptionHolder Class.", e);
            }
            catch (IllegalAccessException e) {
                logger.error("Could not access ExceptionHolder Class.", e);
            }
        }
        HOLDER = exceptionHolder;
    }
}

