/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.route.render;

import com.cybermkd.common.Render;
import com.cybermkd.common.http.ContentType;
import com.cybermkd.common.http.HttpRequest;
import com.cybermkd.common.http.HttpResponse;
import com.cybermkd.common.http.exception.WebException;
import com.cybermkd.common.http.result.HttpStatus;
import com.cybermkd.log.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FileRender
extends Render {
    private static final Logger logger = Logger.getLogger(FileRender.class);

    @Override
    public void render(HttpRequest request, HttpResponse response, Object out) {
        if (out != null) {
            File file = null;
            BufferedInputStream bis = null;
            if (out instanceof String) {
                file = new File((String)out);
            } else if (out instanceof File) {
                file = (File)out;
            }
            if (file == null) {
                throw new WebException(HttpStatus.NOT_FOUND, "File not support '" + out + "'.");
            }
            if (!file.exists()) {
                throw new WebException(HttpStatus.NOT_FOUND, "File not found '" + file.getName() + "'.");
            }
            try {
                String contentRange;
                long p = 0L;
                long toLength = 0L;
                long contentLength = 0L;
                int rangeSwitch = 0;
                String rangBytes = "";
                long fileLength = file.length();
                FileInputStream ins = new FileInputStream(file);
                bis = new BufferedInputStream(ins);
                response.reset();
                response.setHeader("Accept-Ranges", "bytes");
                String range = request.getHeader("Range");
                if (range != null && range.trim().length() > 0 && !"null".equals(range)) {
                    response.setStatus(HttpStatus.PARTIAL_CONTENT);
                    rangBytes = range.replaceAll("bytes=", "");
                    if (rangBytes.endsWith("-")) {
                        rangeSwitch = 1;
                        p = Long.parseLong(rangBytes.substring(0, rangBytes.indexOf("-")));
                        contentLength = fileLength - p;
                    } else {
                        rangeSwitch = 2;
                        String temp1 = rangBytes.substring(0, rangBytes.indexOf("-"));
                        String temp2 = rangBytes.substring(rangBytes.indexOf("-") + 1, rangBytes.length());
                        p = Long.parseLong(temp1);
                        toLength = Long.parseLong(temp2);
                        contentLength = toLength - p + 1L;
                    }
                } else {
                    contentLength = fileLength;
                }
                response.setHeader("Content-Length", Long.toString(contentLength));
                if (rangeSwitch == 1) {
                    contentRange = "bytes " + Long.toString(p) + "-" + Long.toString(fileLength - 1L) + "/" + Long.toString(fileLength);
                    response.setHeader("Content-Range", contentRange);
                    bis.skip(p);
                } else if (rangeSwitch == 2) {
                    contentRange = range.replace("=", " ") + "/" + Long.toString(fileLength);
                    response.setHeader("Content-Range", contentRange);
                    bis.skip(p);
                } else {
                    contentRange = "bytes 0-" + (fileLength - 1L) + "/" + fileLength;
                    response.setHeader("Content-Range", contentRange);
                }
                String fileName = file.getName();
                response.setContentType(ContentType.FILE.value());
                response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
                OutputStream outputStream = response.getOutputStream();
                int n = 0;
                int bsize = 1024;
                byte[] bytes = new byte[bsize];
                if (rangeSwitch == 2) {
                    long readLength;
                    for (readLength = 0L; readLength <= contentLength - (long)bsize; readLength += (long)n) {
                        n = bis.read(bytes);
                        outputStream.write(bytes, 0, n);
                    }
                    if (readLength <= contentLength) {
                        n = bis.read(bytes, 0, (int)(contentLength - readLength));
                        outputStream.write(bytes, 0, n);
                    }
                } else {
                    while ((n = bis.read(bytes)) != -1) {
                        outputStream.write(bytes, 0, n);
                    }
                }
                bis.close();
            }
            catch (IOException p) {
            }
            catch (Exception e) {
                throw new WebException(e.getMessage());
            }
        }
    }
}

