/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.route.render;

import com.cybermkd.common.Render;
import com.cybermkd.route.render.FileRender;
import com.cybermkd.route.render.ImageRender;
import com.cybermkd.route.render.JsonRender;
import com.cybermkd.route.render.TextRender;
import java.util.HashMap;
import java.util.Map;

public class RenderFactory {
    public static final String JSON = "json";
    public static final String TEXT = "text";
    public static final String FILE = "file";
    public static final String IMAGE = "image";
    private static String defaultExtension = "json";
    private static Map<String, Render> renderMap = new HashMap<String, Render>(){
        {
            this.put(RenderFactory.JSON, new JsonRender());
            this.put(RenderFactory.TEXT, new TextRender());
            this.put(RenderFactory.FILE, new FileRender());
            this.put(RenderFactory.IMAGE, new ImageRender());
        }
    };

    public static void add(String extension, Render render) {
        if (!(render instanceof FileRender) && !(render instanceof ImageRender)) {
            renderMap.put(extension, render);
        }
    }

    public static void addDefault(String extension, Render render) {
        if (!(render instanceof FileRender) && !(render instanceof ImageRender)) {
            renderMap.put(extension, render);
            defaultExtension = extension;
        }
    }

    public static Render get(String extension) {
        Render render = renderMap.get(extension);
        if (render == null) {
            return renderMap.get(defaultExtension);
        }
        return render;
    }

    public static Render getByUrl(String url) {
        String extension = "";
        if (url.contains(".")) {
            extension = url.substring(url.lastIndexOf(".") + 1);
        }
        return RenderFactory.get(extension);
    }

    public static boolean contains(String extension) {
        return renderMap.containsKey(extension);
    }

    public static Render getDefaultRender() {
        return RenderFactory.get(defaultExtension);
    }

    public static Render getJsonRender() {
        return renderMap.get(JSON);
    }

    public static Render getTextRender() {
        return renderMap.get(TEXT);
    }

    public static Render getFileRender() {
        return renderMap.get(FILE);
    }

    public static Render getImageRender() {
        return renderMap.get(IMAGE);
    }
}

