/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.server;

import com.cybermkd.common.util.properties.Prop;
import com.cybermkd.log.Logger;
import com.cybermkd.server.IServer;
import com.cybermkd.server.IceRestClassLoader;
import com.cybermkd.server.Scanner;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.webapp.WebAppContext;

class JettyServer
implements IServer {
    private String webAppDir;
    private int port;
    private String context;
    private int scanIntervalSeconds;
    private boolean running = false;
    private Server server;
    private WebAppContext webApp;
    private static Logger logger = Logger.getLogger(JettyServer.class.getName());

    JettyServer(String webAppDir, int port, String context, int scanIntervalSeconds) {
        if (webAppDir == null) {
            throw new IllegalStateException("Invalid webAppDir of web server: " + webAppDir);
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port of web server: " + port);
        }
        if (context == null && context.isEmpty()) {
            throw new IllegalStateException("Invalid context of web server: " + context);
        }
        this.webAppDir = webAppDir;
        this.port = port;
        this.context = context;
        this.scanIntervalSeconds = scanIntervalSeconds;
    }

    @Override
    public void start() {
        if (!this.running) {
            try {
                this.running = true;
                this.doStart();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                logger.error(e.getMessage(), e);
            }
        }
    }

    @Override
    public void stop() {
        if (this.running) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
            this.running = false;
        }
    }

    private void doStart() throws IOException {
        if (!JettyServer.available(this.port)) {
            throw new IllegalStateException("port: " + this.port + " already in use!");
        }
        this.server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(this.port);
        this.server.addConnector((Connector)connector);
        this.webApp = new WebAppContext();
        this.webApp.setThrowUnavailableOnStartupException(true);
        this.webApp.setContextPath(this.context);
        this.webApp.setResourceBase(this.webAppDir);
        this.webApp.setDescriptor(this.webAppDir + "/WEB-INF/web.xml");
        this.webApp.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        this.webApp.setInitParameter("org.eclipse.jetty.servlet.Default.useFileMappedBuffer", "false");
        this.server.setHandler((Handler)this.webApp);
        this.changeClassLoader(this.webApp);
        if (this.scanIntervalSeconds > 0) {
            Scanner scanner = new Scanner(Prop.getRootClassPath(), this.scanIntervalSeconds){

                @Override
                public void onChange() {
                    try {
                        System.err.println("\nLoading changes ......");
                        JettyServer.this.webApp.stop();
                        IceRestClassLoader loader = new IceRestClassLoader(JettyServer.this.webApp, JettyServer.this.getClassPath());
                        JettyServer.this.webApp.setClassLoader((ClassLoader)((Object)loader));
                        JettyServer.this.webApp.start();
                        System.err.println("Loading complete.");
                    }
                    catch (Exception e) {
                        System.err.println("Error reconfiguring/restarting webapp after change in watched files");
                        logger.error(e.getMessage(), e);
                    }
                }
            };
            System.out.println("Starting scanner at interval of " + this.scanIntervalSeconds + " seconds.");
            scanner.start();
        }
        try {
            System.out.println("Starting web server on port: " + this.port);
            this.server.start();
            this.server.join();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            System.exit(100);
        }
    }

    private void changeClassLoader(WebAppContext webApp) {
        try {
            String classPath = this.getClassPath();
            IceRestClassLoader jfcl = new IceRestClassLoader(webApp, classPath);
            jfcl.addClassPath(classPath);
            webApp.setClassLoader((ClassLoader)((Object)jfcl));
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
        }
    }

    private String getClassPath() {
        return System.getProperty("java.class.path");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean available(int port) {
        if (port <= 0) {
            throw new IllegalArgumentException("Invalid start port: " + port);
        }
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.info(e.getMessage());
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException e) {
                    logger.info(e.getMessage());
                }
            }
        }
        return false;
    }
}

