/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.server;

import com.cybermkd.log.Logger;
import com.cybermkd.server.TimeSize;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public abstract class Scanner {
    private Timer timer;
    private TimerTask task;
    private File rootDir;
    private int interval;
    private boolean running = false;
    private final Map<String, TimeSize> preScan = new HashMap<String, TimeSize>();
    private final Map<String, TimeSize> curScan = new HashMap<String, TimeSize>();
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public Scanner(String rootDir, int interval) {
        if (rootDir == null && rootDir.isEmpty()) {
            throw new IllegalArgumentException("The parameter rootDir can not be blank.");
        }
        this.rootDir = new File(rootDir);
        if (!this.rootDir.isDirectory()) {
            throw new IllegalArgumentException("The directory " + rootDir + " is not exists.");
        }
        if (interval <= 0) {
            throw new IllegalArgumentException("The parameter interval must more than zero.");
        }
        this.interval = interval;
    }

    public abstract void onChange();

    private void working() {
        this.scan(this.rootDir);
        this.compare();
        this.preScan.clear();
        this.preScan.putAll(this.curScan);
        this.curScan.clear();
    }

    private void scan(File file) {
        File[] fs;
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isFile()) {
            try {
                this.curScan.put(file.getCanonicalPath(), new TimeSize(file.lastModified(), file.length()));
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), e);
            }
        } else if (file.isDirectory() && (fs = file.listFiles()) != null) {
            for (File f : fs) {
                this.scan(f);
            }
        }
    }

    private void compare() {
        if (this.preScan.size() == 0) {
            return;
        }
        if (!this.preScan.equals(this.curScan)) {
            this.onChange();
        }
    }

    public void start() {
        if (!this.running) {
            this.timer = new Timer("ICEREST-Scanner", true);
            this.task = new TimerTask(){

                @Override
                public void run() {
                    Scanner.this.working();
                }
            };
            this.timer.schedule(this.task, 1010L * (long)this.interval, 1010L * (long)this.interval);
            this.running = true;
        }
    }

    public void stop() {
        if (this.running) {
            this.timer.cancel();
            this.task.cancel();
            this.running = false;
        }
    }
}

