/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.upload.multipart;

import com.cybermkd.upload.multipart.ServletInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BufferedServletInputStream
extends ServletInputStream {
    private InputStream in;
    private byte[] buf = new byte[65536];
    private int count;
    private int pos;

    public BufferedServletInputStream(InputStream in) {
        this.in = in;
    }

    private static int findeol(byte[] b, int pos, int len) {
        int end = pos + len;
        int i = pos;
        while (i < end) {
            if (b[i++] != 10) continue;
            return i - pos;
        }
        return -1;
    }

    private void fill() throws IOException {
        int i = this.in.read(this.buf, 0, this.buf.length);
        if (i > 0) {
            this.pos = 0;
            this.count = i;
        }
    }

    @Override
    public int readLine(byte[] b, int off, int len) throws IOException {
        int copy;
        int eol;
        int total = 0;
        if (len == 0) {
            return 0;
        }
        int avail = this.count - this.pos;
        if (avail <= 0) {
            this.fill();
            avail = this.count - this.pos;
            if (avail <= 0) {
                return -1;
            }
        }
        if ((eol = BufferedServletInputStream.findeol(this.buf, this.pos, copy = Math.min(len, avail))) != -1) {
            copy = eol;
        }
        System.arraycopy(this.buf, this.pos, b, off, copy);
        this.pos += copy;
        total += copy;
        while (total < len && eol == -1) {
            this.fill();
            avail = this.count - this.pos;
            if (avail <= 0) {
                return total;
            }
            copy = Math.min(len - total, avail);
            eol = BufferedServletInputStream.findeol(this.buf, this.pos, copy);
            if (eol != -1) {
                copy = eol;
            }
            System.arraycopy(this.buf, this.pos, b, off + total, copy);
            this.pos += copy;
            total += copy;
        }
        return total;
    }

    @Override
    public int read() throws IOException {
        if (this.count <= this.pos) {
            this.fill();
            if (this.count <= this.pos) {
                return -1;
            }
        }
        return this.buf[this.pos++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int total;
        int copy;
        for (total = 0; total < len; total += copy) {
            int avail = this.count - this.pos;
            if (avail <= 0) {
                this.fill();
                avail = this.count - this.pos;
                if (avail <= 0) {
                    if (total > 0) {
                        return total;
                    }
                    return -1;
                }
            }
            copy = Math.min(len - total, avail);
            System.arraycopy(this.buf, this.pos, b, off + total, copy);
            this.pos += copy;
        }
        return total;
    }
}

