/*
 * Decompiled with CFR 0.152.
 */
package com.cybermkd.upload.multipart;

import com.cybermkd.common.http.exception.WebException;
import com.cybermkd.common.util.stream.FileRenamer;
import com.cybermkd.upload.multipart.MacBinaryDecoderOutputStream;
import com.cybermkd.upload.multipart.Part;
import com.cybermkd.upload.multipart.PartInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FilePart
extends Part {
    private File dir;
    private String fileName;
    private String filePath;
    private String contentType;
    private PartInputStream partInput;
    private FileRenamer renamer;

    FilePart(String name, InputStream in, String boundary, String contentType, String fileName, String filePath) throws IOException {
        super(name);
        this.fileName = fileName;
        this.filePath = filePath;
        this.contentType = contentType;
        this.partInput = new PartInputStream(in, boundary);
    }

    public void setRenamer(FileRenamer renamer) {
        this.renamer = renamer;
    }

    public File getDir() {
        return this.dir;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() {
        return this.partInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeTo(File fileOrDirectory) throws IOException {
        long written = 0L;
        try (OutputStream fileOut = null;){
            if (this.fileName != null) {
                File parent;
                File file = fileOrDirectory.isDirectory() ? new File(fileOrDirectory, this.fileName) : fileOrDirectory;
                if (this.renamer != null) {
                    file = this.renamer.rename(file);
                    this.fileName = file.getName();
                }
                if (!(parent = file.getParentFile()).exists() && !parent.mkdirs()) {
                    throw new WebException("Directory " + parent + " not exists and can not create directory.");
                }
                this.dir = parent;
                fileOut = new BufferedOutputStream(new FileOutputStream(file));
                written = this.write(fileOut);
            }
        }
        return written;
    }

    public long writeTo(OutputStream out) throws IOException {
        long size = 0L;
        if (this.fileName != null) {
            size = this.write(out);
        }
        return size;
    }

    long write(OutputStream out) throws IOException {
        int read;
        if (this.contentType.equals("application/x-macbinary")) {
            out = new MacBinaryDecoderOutputStream(out);
        }
        long size = 0L;
        byte[] buf = new byte[8192];
        while ((read = this.partInput.read(buf)) != -1) {
            out.write(buf, 0, read);
            size += (long)read;
        }
        return size;
    }

    @Override
    public boolean isFile() {
        return true;
    }
}

