/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;

class Row
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int kY;
    private Object[] kZ;
    private Object[] la;
    private boolean[] lb;
    private boolean[] lc;
    private boolean ld;
    private boolean le;
    private int lf;
    private boolean lg;

    public Row(int n2) {
        this.kY = n2;
        this.kZ = new Object[n2];
        this.la = new Object[n2];
        this.lb = new boolean[n2];
        this.lc = new boolean[n2];
        this.ld = false;
        this.le = false;
        this.lf = 0;
        this.lg = false;
    }

    public Row(int n2, boolean bl) {
        this(n2);
        this.le = bl;
    }

    public Row(int n2, Object[] objectArray) {
        this(n2);
        System.arraycopy(objectArray, 0, this.kZ, 0, n2);
    }

    public Object getColumn(int n2) {
        return this.kZ[n2];
    }

    public Object getChangedColumn(int n2) {
        return this.la[n2];
    }

    public Object[] getOriginalRow() {
        return this.kZ;
    }

    public boolean isOriginalNull(int n2) {
        return this.lc[n2];
    }

    public boolean isOriginalWithNull() {
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.kY) {
            if (this.isOriginalNull(n2)) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    void setOriginalNull(int n2, boolean bl) {
        this.lc[n2] = bl;
    }

    public void setColumnValue(int n2, Object object) {
        this.kZ[n2] = object;
        if (this.le) {
            ++this.lf;
        }
    }

    public void updateColumnValue(int n2, Object object) {
        this.lb[n2] = true;
        this.la[n2] = object;
        if (this.le) {
            ++this.lf;
        }
    }

    public boolean isColumnChanged(int n2) {
        return this.lb[n2];
    }

    public void insertRow() {
        System.arraycopy(this.la, 0, this.kZ, 0, this.kY);
        this.lb = null;
        this.lb = new boolean[this.kY];
        this.la = null;
        this.la = new Object[this.kY];
        this.lf = 0;
    }

    public boolean isRowDeleted() {
        return this.lg;
    }

    public boolean isRowInserted() {
        return this.le;
    }

    public boolean isRowUpdated() {
        if (this.lg || this.le) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.kY) {
            if (this.lb[n2]) {
                return true;
            }
            ++n2;
        }
        return this.ld;
    }

    public void cancelRowDeletion() {
        this.lg = false;
    }

    public void cancelRowUpdates() {
        int n2 = 0;
        while (n2 < this.kY) {
            this.lb[n2] = false;
            ++n2;
        }
        this.la = new Object[this.kY];
        this.lf = 0;
    }

    public void setRowUpdated(boolean bl) {
        this.ld = bl;
        if (!bl) {
            this.cancelRowUpdates();
        }
    }

    public void setRowDeleted(boolean bl) {
        this.lg = bl;
    }

    public void setRowInserted(boolean bl) {
        this.le = bl;
    }

    public boolean isRowFullyPopulated() {
        if (!this.le) {
            return false;
        }
        return this.kY == this.lf;
    }

    void setUpdatesOriginal() {
        int n2 = 0;
        while (n2 < this.kY) {
            if (this.lb[n2]) {
                this.kZ[n2] = this.la[n2];
                this.la[n2] = null;
                this.lb[n2] = false;
            }
            ++n2;
        }
        this.ld = false;
    }

    public Collection toCollection() {
        Vector<Object> vector = new Vector<Object>(this.kY);
        int n2 = 0;
        while (n2 < this.kY) {
            vector.add(this.isColumnChanged(n2) ? this.getChangedColumn(n2) : this.getColumn(n2));
            ++n2;
        }
        return vector;
    }

    public Row createCopy() {
        Row row = new Row(this.kY);
        System.arraycopy(this.kZ, 0, row.kZ, 0, this.kY);
        System.arraycopy(this.la, 0, this.la, 0, this.kY);
        System.arraycopy(this.lb, 0, row.lb, 0, this.kY);
        row.lf = this.lf;
        row.lg = this.lg;
        row.le = this.le;
        row.ld = this.ld;
        return row;
    }
}

