/*
 * Decompiled with CFR 0.152.
 */
package akka.testkit;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Terminated;
import akka.event.Logging;
import akka.japi.JavaPartialFunction;
import akka.japi.Util;
import akka.testkit.CachingPartialFunction;
import akka.testkit.DebugFilter;
import akka.testkit.ErrorFilter;
import akka.testkit.InfoFilter;
import akka.testkit.TestActor;
import akka.testkit.TestKit;
import akka.testkit.TestKitExtension;
import akka.testkit.TestProbe;
import akka.testkit.WarningFilter;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.PartialFunction;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.AbstractFunction0;

public class JavaTestKit {
    private final TestProbe p;

    public static void shutdownActorSystem(ActorSystem actorSystem, Duration duration, Boolean bl) {
        boolean bl2 = bl != null ? bl : false;
        Duration duration2 = duration != null ? duration : FiniteDuration.create((long)10L, (TimeUnit)TimeUnit.SECONDS);
        TestKit.shutdownActorSystem(actorSystem, duration2, bl2);
    }

    public static void shutdownActorSystem(ActorSystem actorSystem) {
        JavaTestKit.shutdownActorSystem(actorSystem, null, null);
    }

    public void shutdownActorSystem(ActorSystem actorSystem, Duration duration) {
        JavaTestKit.shutdownActorSystem(actorSystem, duration, null);
    }

    public void shutdownActorSystem(ActorSystem actorSystem, Boolean bl) {
        JavaTestKit.shutdownActorSystem(actorSystem, null, bl);
    }

    public JavaTestKit(ActorSystem actorSystem) {
        this.p = new TestProbe(actorSystem);
    }

    public ActorRef getTestActor() {
        return this.p.testActor();
    }

    public ActorRef getRef() {
        return this.getTestActor();
    }

    public ActorSystem getSystem() {
        return this.p.system();
    }

    public static FiniteDuration duration(String string) {
        Duration duration = Duration.apply((String)string);
        if (duration instanceof FiniteDuration) {
            return (FiniteDuration)duration;
        }
        throw new IllegalArgumentException("duration() is only for finite durations, use Duration.Inf() and friends");
    }

    public Duration dilated(Duration duration) {
        return duration.mul(TestKitExtension.get(this.getSystem()).TestTimeFactor());
    }

    public boolean msgAvailable() {
        return this.p.msgAvailable();
    }

    public ActorRef getLastSender() {
        return this.p.lastMessage().sender();
    }

    public void send(ActorRef actorRef, Object object) {
        actorRef.tell(object, this.p.ref());
    }

    public void forward(ActorRef actorRef) {
        actorRef.tell(this.p.lastMessage().msg(), this.p.lastMessage().sender());
    }

    public void reply(Object object) {
        this.p.lastMessage().sender().tell(object, this.p.ref());
    }

    public FiniteDuration getRemainingTime() {
        return this.p.remaining();
    }

    public FiniteDuration getRemainingTimeOr(FiniteDuration finiteDuration) {
        return this.p.remainingOr(finiteDuration);
    }

    public ActorRef watch(ActorRef actorRef) {
        return this.p.watch(actorRef);
    }

    public ActorRef unwatch(ActorRef actorRef) {
        return this.p.unwatch(actorRef);
    }

    public void ignoreNoMsg() {
        this.p.ignoreNoMsg();
    }

    public void setAutoPilot(TestActor.AutoPilot autoPilot) {
        this.p.setAutoPilot(autoPilot);
    }

    public FiniteDuration remaining() {
        return this.p.remaining();
    }

    public FiniteDuration remainingOr(FiniteDuration finiteDuration) {
        return this.p.remainingOr(finiteDuration);
    }

    public <T> T expectMsgEquals(T t) {
        return this.p.expectMsg(t);
    }

    public <T> T expectMsgEquals(FiniteDuration finiteDuration, T t) {
        return this.p.expectMsg(finiteDuration, t);
    }

    public <T> T expectMsgClass(Class<T> clazz) {
        return this.p.expectMsgClass(clazz);
    }

    public <T> T expectMsgClass(FiniteDuration finiteDuration, Class<T> clazz) {
        return this.p.expectMsgClass(finiteDuration, clazz);
    }

    public Object expectMsgAnyOf(Object ... objectArray) {
        return this.p.expectMsgAnyOf(Util.immutableSeq((Object)objectArray));
    }

    public Object expectMsgAnyOf(FiniteDuration finiteDuration, Object ... objectArray) {
        return this.p.expectMsgAnyOf(finiteDuration, Util.immutableSeq((Object)objectArray));
    }

    public Object[] expectMsgAllOf(Object ... objectArray) {
        return (Object[])this.p.expectMsgAllOf(Util.immutableSeq((Object)objectArray)).toArray(Util.classTag(Object.class));
    }

    public Object[] expectMsgAllOf(FiniteDuration finiteDuration, Object ... objectArray) {
        return (Object[])this.p.expectMsgAllOf(finiteDuration, Util.immutableSeq((Object)objectArray)).toArray(Util.classTag(Object.class));
    }

    public <T> T expectMsgAnyClassOf(Class<? extends T> ... classArray) {
        Object c = this.p.expectMsgAnyClassOf(Util.immutableSeq((Class[])classArray));
        return (T)c;
    }

    public Object expectMsgAnyClassOf(FiniteDuration finiteDuration, Class<?> ... classArray) {
        return this.p.expectMsgAnyClassOf(finiteDuration, Util.immutableSeq((Class[])classArray));
    }

    public void expectNoMsg() {
        this.p.expectNoMsg();
    }

    public void expectNoMsg(FiniteDuration finiteDuration) {
        this.p.expectNoMsg(finiteDuration);
    }

    public Terminated expectTerminated(Duration duration, ActorRef actorRef) {
        return this.p.expectTerminated(actorRef, duration);
    }

    public Terminated expectTerminated(ActorRef actorRef) {
        return this.expectTerminated((Duration)Duration.Undefined(), actorRef);
    }

    public Object[] receiveN(int n) {
        return (Object[])this.p.receiveN(n).toArray(Util.classTag(Object.class));
    }

    public Object[] receiveN(int n, FiniteDuration finiteDuration) {
        return (Object[])this.p.receiveN(n, finiteDuration).toArray(Util.classTag(Object.class));
    }

    public Object receiveOne(Duration duration) {
        return this.p.receiveOne(duration);
    }

    public void shutdown(ActorSystem actorSystem, Duration duration, Boolean bl) {
        boolean bl2 = bl != null ? bl : false;
        Duration duration2 = duration != null ? duration : this.dilated((Duration)FiniteDuration.create((long)5L, (TimeUnit)TimeUnit.SECONDS)).min((Duration)FiniteDuration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
        JavaTestKit.shutdownActorSystem(actorSystem, duration2, bl2);
    }

    public void shutdown(ActorSystem actorSystem) {
        this.shutdown(actorSystem, null, null);
    }

    public void shutdown(ActorSystem actorSystem, Duration duration) {
        this.shutdown(actorSystem, duration, null);
    }

    public void shutdown(ActorSystem actorSystem, Boolean bl) {
        this.shutdown(actorSystem, null, bl);
    }

    public abstract class EventFilter<T> {
        private final Class<? extends Logging.LogEvent> clazz;
        private String source = null;
        private String message = null;
        private boolean pattern = false;
        private boolean complete = false;
        private int occurrences = Integer.MAX_VALUE;
        private Class<? extends Throwable> exceptionType = null;

        protected abstract T run();

        public EventFilter(Class<?> clazz) {
            if (Throwable.class.isAssignableFrom(clazz)) {
                this.clazz = Logging.Error.class;
                this.exceptionType = clazz;
            } else if (Logging.LogEvent.class.isAssignableFrom(clazz)) {
                this.clazz = clazz;
            } else {
                throw new IllegalArgumentException("supplied class must either be LogEvent or Throwable");
            }
        }

        public T exec() {
            akka.testkit.EventFilter eventFilter;
            if (this.clazz == Logging.Error.class) {
                if (this.exceptionType == null) {
                    this.exceptionType = Logging.noCause().getClass();
                }
                eventFilter = new ErrorFilter(this.exceptionType, this.source, this.message, this.pattern, this.complete, this.occurrences);
            } else if (this.clazz == Logging.Warning.class) {
                eventFilter = new WarningFilter(this.source, this.message, this.pattern, this.complete, this.occurrences);
            } else if (this.clazz == Logging.Info.class) {
                eventFilter = new InfoFilter(this.source, this.message, this.pattern, this.complete, this.occurrences);
            } else if (this.clazz == Logging.Debug.class) {
                eventFilter = new DebugFilter(this.source, this.message, this.pattern, this.complete, this.occurrences);
            } else {
                throw new IllegalArgumentException("unknown LogLevel " + this.clazz);
            }
            return eventFilter.intercept(new AbstractFunction0<T>(){

                public T apply() {
                    return EventFilter.this.run();
                }
            }, JavaTestKit.this.p.system());
        }

        public EventFilter<T> message(String string) {
            this.message = string;
            this.pattern = false;
            this.complete = true;
            return this;
        }

        public EventFilter<T> startsWith(String string) {
            this.message = string;
            this.pattern = false;
            this.complete = false;
            return this;
        }

        public EventFilter<T> matches(String string) {
            this.message = string;
            this.pattern = true;
            return this;
        }

        public EventFilter<T> from(String string) {
            this.source = string;
            return this;
        }

        public EventFilter<T> occurrences(int n) {
            this.occurrences = n;
            return this;
        }
    }

    public abstract class ReceiveWhile<T> {
        private Object results;

        protected abstract T match(Object var1) throws Exception;

        public ReceiveWhile(Class<T> clazz) {
            this(clazz, (Duration)Duration.Undefined());
        }

        public ReceiveWhile(Class<T> clazz, Duration duration) {
            this(clazz, duration, (Duration)Duration.Inf(), Integer.MAX_VALUE);
        }

        public ReceiveWhile(Class<T> clazz, Duration duration, int n) {
            this(clazz, duration, (Duration)Duration.Inf(), n);
        }

        public ReceiveWhile(Class<T> clazz, Duration duration, Duration duration2, int n) {
            this.results = JavaTestKit.this.p.receiveWhile(duration, duration2, n, new CachingPartialFunction<Object, T>(){

                @Override
                public T match(Object object) throws Exception {
                    return ReceiveWhile.this.match(object);
                }
            }).toArray(Util.classTag(clazz));
        }

        protected RuntimeException noMatch() {
            throw JavaPartialFunction.noMatch();
        }

        public T[] get() {
            return (Object[])this.results;
        }
    }

    public abstract class ExpectMsg<T> {
        private final T result;

        public ExpectMsg(String string) {
            this((Duration)Duration.Undefined(), string);
        }

        public ExpectMsg(Duration duration, String string) {
            Object object = JavaTestKit.this.p.receiveOne(duration);
            try {
                this.result = this.match(object);
            }
            catch (JavaPartialFunction.NoMatchException noMatchException) {
                throw new AssertionError((Object)("while expecting '" + string + "' received unexpected: " + object));
            }
        }

        protected abstract T match(Object var1);

        protected RuntimeException noMatch() {
            throw JavaPartialFunction.noMatch();
        }

        public T get() {
            return this.result;
        }
    }

    public abstract class AwaitAssert {
        protected abstract void check();

        public AwaitAssert() {
            this((Duration)Duration.Undefined(), javaTestKit.p.awaitAssert$default$3());
        }

        public AwaitAssert(Duration duration) {
            this(duration, javaTestKit.p.awaitAssert$default$3());
        }

        public AwaitAssert(Duration duration, Duration duration2) {
            JavaTestKit.this.p.awaitAssert((Function0<Object>)new AbstractFunction0<Object>(){

                public Object apply() {
                    AwaitAssert.this.check();
                    return null;
                }
            }, duration, duration2);
        }
    }

    public abstract class AwaitCond {
        protected abstract boolean cond();

        public AwaitCond() {
            this((Duration)Duration.Undefined(), javaTestKit.p.awaitCond$default$3());
        }

        public AwaitCond(Duration duration) {
            this(duration, javaTestKit.p.awaitCond$default$3());
        }

        public AwaitCond(Duration duration, Duration duration2) {
            JavaTestKit.this.p.awaitCond((Function0<Object>)new AbstractFunction0<Object>(){

                public Object apply() {
                    return AwaitCond.this.cond();
                }
            }, duration, duration2, JavaTestKit.this.p.awaitCond$default$4());
        }

        public AwaitCond(Duration duration, Duration duration2, String string) {
            JavaTestKit.this.p.awaitCond((Function0<Object>)new AbstractFunction0<Object>(){

                public Object apply() {
                    return AwaitCond.this.cond();
                }
            }, duration, duration2, string);
        }
    }

    public abstract class Within {
        protected abstract void run();

        public Within(FiniteDuration finiteDuration) {
            JavaTestKit.this.p.within(finiteDuration, new AbstractFunction0<Object>(){

                public Object apply() {
                    Within.this.run();
                    return null;
                }
            });
        }

        public Within(FiniteDuration finiteDuration, FiniteDuration finiteDuration2) {
            JavaTestKit.this.p.within(finiteDuration, finiteDuration2, new AbstractFunction0<Object>(){

                public Object apply() {
                    Within.this.run();
                    return null;
                }
            });
        }
    }

    public abstract class IgnoreMsg {
        protected abstract boolean ignore(Object var1);

        public IgnoreMsg() {
            JavaTestKit.this.p.ignoreMsg((PartialFunction<Object, Object>)new JavaPartialFunction<Object, Object>(){

                public Boolean apply(Object object, boolean bl) {
                    return IgnoreMsg.this.ignore(object);
                }
            });
        }
    }
}

