/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.mapping.AnnotationParser;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicInteger;

abstract class ColumnMapper<T> {
    private final String columnName;
    private final String alias;
    protected final String fieldName;
    protected final TypeToken<Object> fieldType;
    protected final Kind kind;
    protected final int position;
    protected final TypeCodec<Object> customCodec;

    protected ColumnMapper(Field field, int position, AtomicInteger columnCounter) {
        this.columnName = AnnotationParser.columnName(field);
        this.alias = columnCounter != null ? AnnotationParser.newAlias(field, columnCounter.incrementAndGet()) : null;
        this.fieldName = field.getName();
        this.fieldType = TypeToken.of((Type)field.getGenericType());
        this.kind = AnnotationParser.kind(field);
        this.position = position;
        this.customCodec = AnnotationParser.customCodec(field);
    }

    public abstract Object getValue(T var1);

    public abstract void setValue(T var1, Object var2);

    public String getColumnName() {
        return this.kind == Kind.COMPUTED ? this.columnName : Metadata.quote((String)this.columnName);
    }

    public String getAlias() {
        return this.alias;
    }

    public TypeCodec<Object> getCustomCodec() {
        return this.customCodec;
    }

    public TypeToken<Object> getJavaType() {
        return this.fieldType;
    }

    public static enum Kind {
        PARTITION_KEY,
        CLUSTERING_COLUMN,
        REGULAR,
        COMPUTED;

    }
}

