/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.data;

import com.deepoove.poi.data.RenderData;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.data.style.TableStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RowRenderData
implements RenderData {
    private List<TextRenderData> rowData;
    private TableStyle style;

    public RowRenderData() {
    }

    public RowRenderData(List<TextRenderData> rowData) {
        this.rowData = rowData;
    }

    public static RowRenderData build(String ... row) {
        RowRenderData instance = new RowRenderData();
        instance.rowData = new ArrayList<TextRenderData>();
        for (String col : row) {
            instance.rowData.add(new TextRenderData(col));
        }
        return instance;
    }

    public static RowRenderData build(TextRenderData ... row) {
        RowRenderData instance = new RowRenderData();
        instance.rowData = null == row ? null : Arrays.asList(row);
        return instance;
    }

    public RowRenderData(List<TextRenderData> rowData, String backgroundColor) {
        this.rowData = rowData;
        TableStyle style = new TableStyle();
        style.setBackgroundColor(backgroundColor);
        this.style = style;
    }

    public int size() {
        return null == this.rowData ? 0 : this.rowData.size();
    }

    public List<TextRenderData> getRowData() {
        return this.rowData;
    }

    public void setRowData(List<TextRenderData> rowData) {
        this.rowData = rowData;
    }

    public TableStyle getStyle() {
        return this.style;
    }

    public void setStyle(TableStyle style) {
        this.style = style;
    }
}

