/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.file;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.multipart.ForestMultipart;
import com.dtflys.forest.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.io.Resource;

public class SpringResource
extends ForestMultipart<Resource> {
    private Resource resource;

    public void setData(Resource data) {
        this.resource = data;
    }

    public String getOriginalFileName() {
        if (StringUtils.isNotBlank((String)this.fileName)) {
            return this.fileName;
        }
        return this.resource.getFilename();
    }

    public InputStream getInputStream() {
        try {
            return this.resource.getInputStream();
        }
        catch (IOException e) {
            throw new ForestRuntimeException((Throwable)e);
        }
    }

    public long getSize() {
        try {
            return this.resource.contentLength();
        }
        catch (IOException e) {
            throw new ForestRuntimeException((Throwable)e);
        }
    }

    public boolean isFile() {
        return true;
    }

    public File getFile() {
        try {
            return this.resource.getFile();
        }
        catch (IOException e) {
            throw new ForestRuntimeException((Throwable)e);
        }
    }
}

